/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective;

import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.problem.ConstrainedProblem;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.solutionattribute.impl.NumberOfViolatedConstraints;
import org.uma.jmetal.util.solutionattribute.impl.OverallConstraintViolation;

public class ConstrEx
extends AbstractDoubleProblem
implements ConstrainedProblem<DoubleSolution> {
    public OverallConstraintViolation<DoubleSolution> overallConstraintViolationDegree;
    public NumberOfViolatedConstraints<DoubleSolution> numberOfViolatedConstraints;

    public ConstrEx() {
        this.setNumberOfVariables(2);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(2);
        this.setName("ConstrEx");
        List<Double> lowerLimit = Arrays.asList(0.1, 0.0);
        List<Double> upperLimit = Arrays.asList(1.0, 5.0);
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
        this.overallConstraintViolationDegree = new OverallConstraintViolation();
        this.numberOfViolatedConstraints = new NumberOfViolatedConstraints();
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        double[] f = new double[this.getNumberOfObjectives()];
        f[0] = (Double)solution.getVariableValue(0);
        f[1] = (1.0 + (Double)solution.getVariableValue(1)) / (Double)solution.getVariableValue(0);
        solution.setObjective(0, f[0]);
        solution.setObjective(1, f[1]);
    }

    @Override
    public void evaluateConstraints(DoubleSolution solution) {
        double[] constraint = new double[this.getNumberOfConstraints()];
        double x1 = (Double)solution.getVariableValue(0);
        double x2 = (Double)solution.getVariableValue(1);
        constraint[0] = x2 + 9.0 * x1 - 6.0;
        constraint[1] = -x2 + 9.0 * x1 - 1.0;
        double overallConstraintViolation = 0.0;
        int violatedConstraints = 0;
        for (int i = 0; i < this.getNumberOfConstraints(); ++i) {
            if (!(constraint[i] < 0.0)) continue;
            overallConstraintViolation += constraint[i];
            ++violatedConstraints;
        }
        this.overallConstraintViolationDegree.setAttribute(solution, overallConstraintViolation);
        this.numberOfViolatedConstraints.setAttribute(solution, violatedConstraints);
    }
}

