/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.outlier;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.outlier.OutlierROCCurve;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.geometry.XYCurve;
import de.lmu.ifi.dbs.elki.result.OrderingResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.List;
import java.util.regex.Pattern;

@Reference(authors="W. Klement, P. A. Flach, N. Japkowicz, S. Matwin", title="Smooth Receiver Operating Characteristics (smROC) Curves", booktitle="In: European Conference on Machine Learning and Principles and Practice of Knowledge Discovery in Databases (ECML-PKDD'11)", url="http://dx.doi.org/10.1007/978-3-642-23783-6_13")
public class OutlierSmROCCurve
implements Evaluator {
    public static final String SMROCAUC_LABEL = "ROCAUC";
    private static final Logging LOG = Logging.getLogger(OutlierSmROCCurve.class);
    private Pattern positiveClassName;

    public OutlierSmROCCurve(Pattern pattern) {
        this.positiveClassName = pattern;
    }

    private SmROCResult computeSmROCResult(SetDBIDs setDBIDs, OutlierResult outlierResult) {
        DoubleRelation doubleRelation = outlierResult.getScores();
        int n = doubleRelation.size();
        double d = 0.0;
        Object object = doubleRelation.iterDBIDs();
        while (object.valid()) {
            d += doubleRelation.doubleValue((DBIDRef)object) / (double)n;
            object.advance();
        }
        object = new SmROCResult(setDBIDs.size() + 2);
        ((XYCurve)object).add(0.0, 0.0);
        int n2 = 0;
        int n3 = 0;
        double d2 = Double.NaN;
        double d3 = 0.0;
        double d4 = 0.0;
        DBIDArrayMIter dBIDArrayMIter = outlierResult.getOrdering().order(outlierResult.getOrdering().getDBIDs()).iter();
        while (dBIDArrayMIter.valid()) {
            double d5 = doubleRelation.doubleValue(dBIDArrayMIter);
            if (!Double.isNaN(d2) && Double.compare(d2, d5) == 0) {
                if (setDBIDs.contains(dBIDArrayMIter)) {
                    ++n2;
                } else {
                    ++n3;
                }
            } else {
                if (d2 > d) {
                    d4 += (double)n2 * d2 + (double)n3 * (1.0 - d2);
                    d3 += (double)n2 * (1.0 - d2) + (double)n3 * d2;
                } else if (d2 < d) {
                    d4 += (double)n2 * (1.0 - d2) + (double)n3 * d2;
                    d3 += (double)n2 * d2 + (double)n3 * (1.0 - d2);
                }
                ((XYCurve)object).addAndSimplify(d3, d4);
                if (setDBIDs.contains(dBIDArrayMIter)) {
                    n2 = 1;
                    n3 = 0;
                } else {
                    n2 = 0;
                    n3 = 1;
                }
                d2 = d5;
            }
            dBIDArrayMIter.advance();
        }
        if (d2 > d) {
            d4 += (double)n2 * d2 + (double)n3 * (1.0 - d2);
            d3 += (double)n2 * (1.0 - d2) + (double)n3 * d2;
        } else if (d2 < d) {
            d4 += (double)n2 * (1.0 - d2) + (double)n3 * d2;
            d3 += (double)n2 * d2 + (double)n3 * (1.0 - d2);
        }
        ((XYCurve)object).addAndSimplify(d3, d4);
        double d6 = XYCurve.areaUnderCurve((XYCurve)object) / (d3 * d4);
        if (LOG.isVerbose()) {
            LOG.verbose("ROCAUC: " + d6);
        }
        ((SmROCResult)object).rocauc = d6;
        return object;
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        Database database = ResultUtil.findDatabase(resultHierarchy);
        SetDBIDs setDBIDs = DBIDUtil.ensureSet(DatabaseUtil.getObjectsByLabelMatch(database, this.positiveClassName));
        if (setDBIDs.size() == 0) {
            LOG.warning("Computing a ROC curve failed - no objects matched.");
            return;
        }
        List<OutlierResult> list = ResultUtil.getOutlierResults(result);
        List<OrderingResult> list2 = ResultUtil.getOrderingResults(result);
        for (OutlierResult outlierResult : list) {
            database.getHierarchy().add(outlierResult, this.computeSmROCResult(setDBIDs, outlierResult));
            list2.remove(outlierResult.getOrdering());
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected Pattern positiveClassName = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            PatternParameter patternParameter = new PatternParameter(OutlierROCCurve.Parameterizer.POSITIVE_CLASS_NAME_ID);
            if (parameterization.grab(patternParameter)) {
                this.positiveClassName = (Pattern)patternParameter.getValue();
            }
        }

        @Override
        protected OutlierSmROCCurve makeInstance() {
            return new OutlierSmROCCurve(this.positiveClassName);
        }
    }

    public static class SmROCResult
    extends XYCurve {
        double rocauc = Double.NaN;

        public SmROCResult(int n) {
            super("SmROC Negative", "SmROC Positive", n);
        }

        @Override
        public String getLongName() {
            return "SmROC Curve";
        }

        @Override
        public String getShortName() {
            return "smroc-curve";
        }

        public double getAUC() {
            return this.rocauc;
        }
    }
}

