/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.pairs;

import java.util.Comparator;

public class DoubleIntPair
implements Comparable<DoubleIntPair> {
    public double first;
    public int second;
    public static final Comparator<DoubleIntPair> BYFIRST_COMPARATOR = new Comparator<DoubleIntPair>(){

        @Override
        public int compare(DoubleIntPair doubleIntPair, DoubleIntPair doubleIntPair2) {
            return Double.compare(doubleIntPair.first, doubleIntPair2.first);
        }
    };
    public static final Comparator<DoubleIntPair> BYSECOND_COMPARATOR = new Comparator<DoubleIntPair>(){

        @Override
        public int compare(DoubleIntPair doubleIntPair, DoubleIntPair doubleIntPair2) {
            return doubleIntPair.second - doubleIntPair2.second;
        }
    };
    public static final Comparator<DoubleIntPair> SWAPPED_COMPARATOR = new Comparator<DoubleIntPair>(){

        @Override
        public int compare(DoubleIntPair doubleIntPair, DoubleIntPair doubleIntPair2) {
            return doubleIntPair.compareSwappedTo(doubleIntPair2);
        }
    };

    public DoubleIntPair(double d, int n) {
        this.first = d;
        this.second = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DoubleIntPair doubleIntPair = (DoubleIntPair)object;
        return this.first == doubleIntPair.first && this.second == doubleIntPair.second;
    }

    public final int hashCode() {
        long l = Double.doubleToLongBits(this.first);
        l ^= l >> 32;
        return (int)(l * 2654435761L + (long)this.second);
    }

    @Override
    public int compareTo(DoubleIntPair doubleIntPair) {
        int n = Double.compare(this.first, doubleIntPair.first);
        if (n != 0) {
            return n;
        }
        return this.second - doubleIntPair.second;
    }

    public int compareSwappedTo(DoubleIntPair doubleIntPair) {
        int n = this.second - doubleIntPair.second;
        if (n != 0) {
            return n;
        }
        return Double.compare(this.second, doubleIntPair.second);
    }

    public final void setFirst(double d) {
        this.first = d;
    }

    public final void setSecond(int n) {
        this.second = n;
    }
}

