/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.FileUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.visualization.batikutil.CloneInlineImages;
import de.lmu.ifi.dbs.elki.visualization.batikutil.ThumbnailTranscoder;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClassManager;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.svg.UpdateRunner;
import de.lmu.ifi.dbs.elki.visualization.svg.UpdateSynchronizer;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGPoint;

public class SVGPlot {
    public static final double DEFAULT_QUALITY = 0.85;
    public static final String NO_EXPORT_ATTRIBUTE = "noexport";
    private static final DOMImplementation BATIK_DOM;
    private static final String[] BATIK_DOMS;
    private SVGDocument document;
    private Element root;
    private Element defs;
    private Element style;
    private CSSClassManager cssman;
    private HashMap<String, WeakReference<Element>> objWithId = new HashMap();
    private UpdateRunner runner = new UpdateRunner(this);
    private boolean disableInteractions = false;

    public SVGPlot() {
        DOMImplementation dOMImplementation = SVGPlot.getDomImpl();
        DocumentType documentType = dOMImplementation.createDocumentType("svg", "-//W3C//DTD SVG 1.0//EN", "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd");
        if (documentType.getName() == null) {
            documentType = null;
        }
        this.document = (SVGDocument)dOMImplementation.createDocument("http://www.w3.org/2000/svg", "svg", documentType);
        this.root = this.document.getDocumentElement();
        this.root.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        this.root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xlink", "http://www.w3.org/1999/xlink");
        this.defs = this.svgElement("defs");
        this.root.appendChild(this.defs);
        this.style = SVGUtil.makeStyleElement(this.document);
        this.root.appendChild(this.style);
        this.cssman = new CSSClassManager();
    }

    public static DOMImplementation getDomImpl() {
        if (BATIK_DOM == null) {
            throw new AbortException("No usable Apache Batik SVG DOM could be located.");
        }
        return BATIK_DOM;
    }

    public void dispose() {
        this.runner.clear();
    }

    public Element svgElement(String string) {
        return SVGUtil.svgElement(this.document, string);
    }

    public Element svgRect(double d, double d2, double d3, double d4) {
        return SVGUtil.svgRect(this.document, d, d2, d3, d4);
    }

    public Element svgCircle(double d, double d2, double d3) {
        return SVGUtil.svgCircle(this.document, d, d2, d3);
    }

    public Element svgLine(double d, double d2, double d3, double d4) {
        return SVGUtil.svgLine(this.document, d, d2, d3, d4);
    }

    public Element svgText(double d, double d2, String string) {
        return SVGUtil.svgText(this.document, d, d2, string);
    }

    public SVGPoint elementCoordinatesFromEvent(Element element, Event event) {
        return SVGUtil.elementCoordinatesFromEvent(this.document, element, event);
    }

    public SVGDocument getDocument() {
        return this.document;
    }

    public Element getRoot() {
        return this.root;
    }

    public Element getDefs() {
        return this.defs;
    }

    @Deprecated
    public Element getStyle() {
        return this.style;
    }

    public CSSClassManager getCSSClassManager() {
        return this.cssman;
    }

    public void addCSSClassOrLogError(CSSClass cSSClass) {
        try {
            this.cssman.addClass(cSSClass);
        }
        catch (CSSClassManager.CSSNamingConflict cSSNamingConflict) {
            LoggingUtil.exception(cSSNamingConflict);
        }
    }

    public void updateStyleElement() {
        Element element = this.cssman.makeStyleElement(this.document);
        this.style.getParentNode().replaceChild(element, this.style);
        this.style = element;
    }

    public void saveAsSVG(File file) throws IOException, TransformerFactoryConfigurationError, TransformerException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        StreamResult streamResult = new StreamResult(bufferedOutputStream);
        SVGDocument sVGDocument = this.cloneDocument();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(new DOMSource(sVGDocument), streamResult);
        ((OutputStream)bufferedOutputStream).flush();
        ((OutputStream)bufferedOutputStream).close();
    }

    protected void transcode(File file, Transcoder transcoder) throws IOException, TranscoderException {
        transcoder.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_VALIDATING, Boolean.FALSE);
        SVGDocument sVGDocument = this.cloneDocument();
        TranscoderInput transcoderInput = new TranscoderInput(sVGDocument);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        TranscoderOutput transcoderOutput = new TranscoderOutput(bufferedOutputStream);
        transcoder.transcode(transcoderInput, transcoderOutput);
        ((OutputStream)bufferedOutputStream).flush();
        ((OutputStream)bufferedOutputStream).close();
    }

    protected SVGDocument cloneDocument() {
        return (SVGDocument)new CloneNoExport().cloneDocument(SVGPlot.getDomImpl(), this.document);
    }

    public void saveAsPDF(File file) throws IOException, TranscoderException, ClassNotFoundException {
        try {
            Object obj = Class.forName("org.apache.fop.svg.PDFTranscoder").newInstance();
            this.transcode(file, (Transcoder)obj);
        }
        catch (InstantiationException instantiationException) {
            throw new ClassNotFoundException("Could not instantiate PDF transcoder - is Apache FOP installed?", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ClassNotFoundException("Could not instantiate PDF transcoder - is Apache FOP installed?", illegalAccessException);
        }
    }

    public void saveAsPS(File file) throws IOException, TranscoderException, ClassNotFoundException {
        try {
            Object obj = Class.forName("org.apache.fop.render.ps.PSTranscoder").newInstance();
            this.transcode(file, (Transcoder)obj);
        }
        catch (InstantiationException instantiationException) {
            throw new ClassNotFoundException("Could not instantiate PS transcoder - is Apache FOP installed?", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ClassNotFoundException("Could not instantiate PS transcoder - is Apache FOP installed?", illegalAccessException);
        }
    }

    public void saveAsEPS(File file) throws IOException, TranscoderException, ClassNotFoundException {
        try {
            Object obj = Class.forName("org.apache.fop.render.ps.EPSTranscoder").newInstance();
            this.transcode(file, (Transcoder)obj);
        }
        catch (InstantiationException instantiationException) {
            throw new ClassNotFoundException("Could not instantiate EPS transcoder - is Apache FOP installed?", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ClassNotFoundException("Could not instantiate EPS transcoder - is Apache FOP installed?", illegalAccessException);
        }
    }

    public void saveAsPNG(File file, int n, int n2) throws IOException, TranscoderException {
        PNGTranscoder pNGTranscoder = new PNGTranscoder();
        pNGTranscoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, new Float(n));
        pNGTranscoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, new Float(n2));
        this.transcode(file, pNGTranscoder);
    }

    public void saveAsJPEG(File file, int n, int n2, double d) throws IOException, TranscoderException {
        JPEGTranscoder jPEGTranscoder = new JPEGTranscoder();
        jPEGTranscoder.addTranscodingHint(JPEGTranscoder.KEY_WIDTH, new Float(n));
        jPEGTranscoder.addTranscodingHint(JPEGTranscoder.KEY_HEIGHT, new Float(n2));
        jPEGTranscoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, new Float(d));
        this.transcode(file, jPEGTranscoder);
    }

    public void saveAsJPEG(File file, int n, int n2) throws IOException, TranscoderException {
        this.saveAsJPEG(file, n, n2, 0.85);
    }

    public void saveAsANY(File file, int n, int n2, double d) throws IOException, TranscoderException, TransformerFactoryConfigurationError, TransformerException, ClassNotFoundException {
        String string = FileUtil.getFilenameExtension(file);
        if (string.equals("svg")) {
            this.saveAsSVG(file);
        } else if (string.equals("pdf")) {
            this.saveAsPDF(file);
        } else if (string.equals("ps")) {
            this.saveAsPS(file);
        } else if (string.equals("eps")) {
            this.saveAsEPS(file);
        } else if (string.equals("png")) {
            this.saveAsPNG(file, n, n2);
        } else if (string.equals("jpg") || string.equals("jpeg")) {
            this.saveAsJPEG(file, n, n2, d);
        } else {
            throw new IOException("Unknown file extension: " + string);
        }
    }

    public BufferedImage makeAWTImage(int n, int n2) throws TranscoderException {
        ThumbnailTranscoder thumbnailTranscoder = new ThumbnailTranscoder();
        thumbnailTranscoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, new Float(n));
        thumbnailTranscoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, new Float(n2));
        TranscoderInput transcoderInput = new TranscoderInput(this.document);
        thumbnailTranscoder.transcode(transcoderInput, null);
        return thumbnailTranscoder.getLastImage();
    }

    public void dumpDebugFile() {
        try {
            File file = File.createTempFile("elki-debug", ".svg");
            file.deleteOnExit();
            this.saveAsSVG(file);
            LoggingUtil.warning("Saved debug file to: " + file.getAbsolutePath());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void putIdElement(String string, Element element) {
        this.objWithId.put(string, new WeakReference<Element>(element));
    }

    public Element getIdElement(String string) {
        WeakReference<Element> weakReference = this.objWithId.get(string);
        return weakReference != null ? (Element)weakReference.get() : null;
    }

    protected Collection<String> getAllIds() {
        return this.objWithId.keySet();
    }

    public void scheduleUpdate(Runnable runnable) {
        this.runner.invokeLater(runnable);
    }

    public void synchronizeWith(UpdateSynchronizer updateSynchronizer) {
        this.runner.synchronizeWith(updateSynchronizer);
    }

    public void unsynchronizeWith(UpdateSynchronizer updateSynchronizer) {
        this.runner.unsynchronizeWith(updateSynchronizer);
    }

    public boolean getDisableInteractions() {
        return this.disableInteractions;
    }

    public void setDisableInteractions(boolean bl) {
        this.disableInteractions = bl;
    }

    static {
        BATIK_DOMS = new String[]{"org.apache.batik.anim.dom.SVGDOMImplementation", "org.apache.batik.dom.svg.SVGDOMImplementation", "com.sun.org.apache.xerces.internal.dom.DOMImplementationImpl"};
        DOMImplementation dOMImplementation = null;
        for (String string : BATIK_DOMS) {
            try {
                Class<?> clazz = Class.forName(string);
                Method method = clazz.getDeclaredMethod("getDOMImplementation", new Class[0]);
                DOMImplementation dOMImplementation2 = (DOMImplementation)DOMImplementation.class.cast(method.invoke(null, new Object[0]));
                if (dOMImplementation2 == null) continue;
                dOMImplementation = dOMImplementation2;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BATIK_DOM = dOMImplementation;
    }

    protected class CloneNoExport
    extends CloneInlineImages {
        protected CloneNoExport() {
        }

        @Override
        public Node cloneNode(Document document, Node node) {
            Element element;
            String string;
            if (node instanceof Element && (string = (element = (Element)node).getAttribute(SVGPlot.NO_EXPORT_ATTRIBUTE)) != null && string.length() > 0) {
                return null;
            }
            return super.cloneNode(document, node);
        }
    }
}

