/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.merge;

import java.util.LinkedList;
import org.eclipse.epsilon.egl.merge.Merger;
import org.eclipse.epsilon.egl.merge.output.ProtectedRegion;
import org.eclipse.epsilon.egl.merge.partition.Partitioner;
import org.eclipse.epsilon.egl.status.ProtectedRegionWarning;

public class DefaultMerger
extends Merger {
    public DefaultMerger(Partitioner partitioner, String generated, String existing) {
        super(partitioner, generated, existing);
    }

    @Override
    public String merge() {
        this.warnings.clear();
        LinkedList<String> idsPresentInGenerated = new LinkedList<String>();
        for (ProtectedRegion generatedRegion : this.generated.getProtectedRegions()) {
            ProtectedRegion existingRegion = this.existing.getProtectedRegion(generatedRegion.getId());
            idsPresentInGenerated.add(generatedRegion.getId());
            if (existingRegion == null || !existingRegion.isEnabled()) continue;
            generatedRegion.setEnabled(true);
            generatedRegion.setContents(existingRegion.getContents());
        }
        for (ProtectedRegion existingRegion : this.existing.getProtectedRegions()) {
            if (idsPresentInGenerated.contains(existingRegion.getId())) continue;
            this.warnings.add(new ProtectedRegionWarning(existingRegion.getId()));
        }
        return this.generated.toString();
    }
}

