/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.util;

public abstract class StringUtil {
    private StringUtil() {
    }

    public static String normalizeNewlines(String s) {
        return s.replaceAll("\r\n", "\n").replaceAll("\r", "\n");
    }

    public static boolean isWhitespace(String s) {
        char[] chars = s.toCharArray();
        boolean charsAreWhitespace = true;
        int index = 0;
        while (charsAreWhitespace && index < chars.length) {
            charsAreWhitespace = Character.isWhitespace(chars[index++]);
        }
        return charsAreWhitespace;
    }

    public static String repeat(String text, int times) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        while (count < times) {
            sb.append(text);
            ++count;
        }
        return sb.toString();
    }

    public static String tabs(int times) {
        return StringUtil.repeat("\t", times);
    }
}

