/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.smsemoa;

import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.smsemoa.SMSEMOA;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.selection.RandomSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.AlgorithmBuilder;

public class SMSEMOABuilder<S extends Solution<?>>
implements AlgorithmBuilder<SMSEMOA<S>> {
    private static final double DEFAULT_OFFSET = 100.0;
    protected Problem<S> problem;
    protected int populationSize;
    protected int maxEvaluations;
    protected CrossoverOperator<S> crossoverOperator;
    protected MutationOperator<S> mutationOperator;
    protected SelectionOperator<List<S>, S> selectionOperator;
    protected double offset;

    public SMSEMOABuilder(Problem<S> problem, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator) {
        this.problem = problem;
        this.offset = 100.0;
        this.populationSize = 100;
        this.maxEvaluations = 25000;
        this.crossoverOperator = crossoverOperator;
        this.mutationOperator = mutationOperator;
        this.selectionOperator = new RandomSelection();
    }

    public SMSEMOABuilder<S> setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
        return this;
    }

    public SMSEMOABuilder<S> setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations;
        return this;
    }

    public SMSEMOABuilder<S> setCrossoverOperator(CrossoverOperator<S> crossover) {
        this.crossoverOperator = crossover;
        return this;
    }

    public SMSEMOABuilder<S> setMutationOperator(MutationOperator<S> mutation) {
        this.mutationOperator = mutation;
        return this;
    }

    public SMSEMOABuilder<S> setSelectionOperator(SelectionOperator<List<S>, S> selection) {
        this.selectionOperator = selection;
        return this;
    }

    public SMSEMOABuilder<S> setOffset(double offset) {
        this.offset = offset;
        return this;
    }

    @Override
    public SMSEMOA<S> build() {
        return new SMSEMOA<S>(this.problem, this.maxEvaluations, this.populationSize, this.offset, this.crossoverOperator, this.mutationOperator, this.selectionOperator);
    }

    public Problem<S> getProblem() {
        return this.problem;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public CrossoverOperator<S> getCrossoverOperator() {
        return this.crossoverOperator;
    }

    public MutationOperator<S> getMutationOperator() {
        return this.mutationOperator;
    }

    public SelectionOperator<List<S>, S> getSelectionOperator() {
        return this.selectionOperator;
    }

    public double getOffset() {
        return this.offset;
    }
}

