/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.io.FileNotFoundException;
import java.util.List;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.front.util.FrontUtils;
import org.uma.jmetal.util.naming.impl.SimpleDescribedEntity;

public class Hypervolume<Evaluate extends List<? extends Solution<?>>>
extends SimpleDescribedEntity
implements QualityIndicator<Evaluate, Double> {
    private Front referenceParetoFront;

    public Hypervolume() {
        super("HV", "Hypervolume quality indicator");
    }

    public Hypervolume(String referenceParetoFrontFile) throws FileNotFoundException {
        this();
        ArrayFront front = new ArrayFront(referenceParetoFrontFile);
        this.referenceParetoFront = front;
    }

    public Hypervolume(Front referenceParetoFront) {
        this();
        if (referenceParetoFront == null) {
            throw new JMetalException("The pareto front is null");
        }
        this.referenceParetoFront = referenceParetoFront;
    }

    @Override
    public Double evaluate(Evaluate paretoFrontApproximation) {
        if (paretoFrontApproximation == null) {
            throw new JMetalException("The pareto front approximation is null");
        }
        return this.hypervolume(new ArrayFront((List<? extends Solution<?>>)paretoFrontApproximation), this.referenceParetoFront);
    }

    @Override
    public String getName() {
        return super.getName();
    }

    private boolean dominates(double[] point1, double[] point2, int noObjectives) {
        int i;
        int betterInAnyObjective = 0;
        for (i = 0; i < noObjectives && point1[i] >= point2[i]; ++i) {
            if (!(point1[i] > point2[i])) continue;
            betterInAnyObjective = 1;
        }
        return i >= noObjectives && betterInAnyObjective > 0;
    }

    private void swap(double[][] front, int i, int j) {
        double[] temp = front[i];
        front[i] = front[j];
        front[j] = temp;
    }

    private int filterNondominatedSet(double[][] front, int noPoints, int noObjectives) {
        int n = noPoints;
        block0: for (int i = 0; i < n; ++i) {
            int j = i + 1;
            while (j < n) {
                if (this.dominates(front[i], front[j], noObjectives)) {
                    this.swap(front, j, --n);
                    continue;
                }
                if (this.dominates(front[j], front[i], noObjectives)) {
                    this.swap(front, i, --n);
                    --i;
                    continue block0;
                }
                ++j;
            }
        }
        return n;
    }

    private double surfaceUnchangedTo(double[][] front, int noPoints, int objective) {
        if (noPoints < 1) {
            new JMetalException("run-time error");
        }
        double minValue = front[0][objective];
        for (int i = 1; i < noPoints; ++i) {
            double value = front[i][objective];
            if (!(value < minValue)) continue;
            minValue = value;
        }
        return minValue;
    }

    private int reduceNondominatedSet(double[][] front, int noPoints, int objective, double threshold) {
        int n = noPoints;
        for (int i = 0; i < n; ++i) {
            if (!(front[i][objective] <= threshold)) continue;
            this.swap(front, i, --n);
        }
        return n;
    }

    public double calculateHypervolume(double[][] front, int noPoints, int noObjectives) {
        double volume = 0.0;
        double distance = 0.0;
        int n = noPoints;
        while (n > 0) {
            double tempVolume;
            int nonDominatedPoints = this.filterNondominatedSet(front, n, noObjectives - 1);
            if (noObjectives < 3) {
                if (nonDominatedPoints < 1) {
                    new JMetalException("run-time error");
                }
                tempVolume = front[0][0];
            } else {
                tempVolume = this.calculateHypervolume(front, nonDominatedPoints, noObjectives - 1);
            }
            double tempDistance = this.surfaceUnchangedTo(front, n, noObjectives - 1);
            volume += tempVolume * (tempDistance - distance);
            distance = tempDistance;
            n = this.reduceNondominatedSet(front, n, noObjectives - 1, distance);
        }
        return volume;
    }

    private double hypervolume(Front front, Front referenceFront) {
        Front invertedFront = FrontUtils.getInvertedFront(front);
        int numberOfObjectives = referenceFront.getPoint(0).getNumberOfDimensions();
        return this.calculateHypervolume(FrontUtils.convertFrontToArray(invertedFront), invertedFront.getNumberOfPoints(), numberOfObjectives);
    }
}

