/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;

public class SplashWindow
extends Window {
    private static final long serialVersionUID = -2685134277041307795L;
    private static SplashWindow m_instance;
    private final Image image;
    private boolean paintCalled = false;

    private SplashWindow(Frame parent, Image image) {
        super(parent);
        this.image = image;
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(image, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int imgWidth = image.getWidth(this);
        int imgHeight = image.getHeight(this);
        this.setSize(imgWidth, imgHeight);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenDim.width - imgWidth) / 2, (screenDim.height - imgHeight) / 2);
        MouseAdapter disposeOnClick = new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent evt) {
                SplashWindow splashWindow = SplashWindow.this;
                synchronized (splashWindow) {
                    SplashWindow.this.paintCalled = true;
                    SplashWindow.this.notifyAll();
                }
                SplashWindow.this.dispose();
            }
        };
        this.addMouseListener(disposeOnClick);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        g.drawImage(this.image, 0, 0, this);
        if (!this.paintCalled) {
            this.paintCalled = true;
            SplashWindow splashWindow = this;
            synchronized (splashWindow) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void splash(Image image) {
        if (m_instance != null) return;
        if (image == null) return;
        Frame f = new Frame();
        m_instance = new SplashWindow(f, image);
        m_instance.show();
        if (EventQueue.isDispatchThread()) return;
        if (Runtime.getRuntime().availableProcessors() != 1) return;
        SplashWindow splashWindow = m_instance;
        synchronized (splashWindow) {
            while (true) {
                if (SplashWindow.m_instance.paintCalled) {
                    return;
                }
                try {
                    m_instance.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static void splash(URL imageURL) {
        if (imageURL != null) {
            SplashWindow.splash(Toolkit.getDefaultToolkit().createImage(imageURL));
        }
    }

    public static void disposeSplash() {
        if (m_instance != null) {
            m_instance.getOwner().dispose();
            m_instance = null;
        }
    }

    public static void invokeMethod(String className, String methodName, String[] args) {
        try {
            Class.forName(className).getMethod(methodName, String[].class).invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            InternalError error = new InternalError("Failed to invoke method: " + methodName);
            error.initCause(e);
            throw error;
        }
    }

    public static void invokeMain(String className, String[] args) {
        try {
            Class.forName(className).getMethod("main", String[].class).invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            InternalError error = new InternalError("Failed to invoke main method");
            error.initCause(e);
            throw error;
        }
    }
}

