/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.benchmark;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.LinearScanQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.datasource.DatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.AbstractParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.regex.Pattern;

public class ValidateApproximativeKNNIndex<O>
extends AbstractDistanceBasedAlgorithm<O, Result> {
    private static final Logging LOG = Logging.getLogger(ValidateApproximativeKNNIndex.class);
    protected int k = 10;
    protected DatabaseConnection queries = null;
    protected double sampling = -1.0;
    protected boolean forcelinear = false;
    protected RandomFactory random;
    protected Pattern pattern;

    public ValidateApproximativeKNNIndex(DistanceFunction<? super O> distanceFunction, int n, DatabaseConnection databaseConnection, double d, boolean bl, RandomFactory randomFactory, Pattern pattern) {
        super(distanceFunction);
        this.k = n;
        this.queries = databaseConnection;
        this.sampling = d;
        this.forcelinear = bl;
        this.random = randomFactory;
        this.pattern = pattern;
    }

    public Result run(Database database, Relation<O> relation) {
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<Object> kNNQuery = database.getKNNQuery(distanceQuery, this.k, "optimized");
        if (kNNQuery == null || kNNQuery instanceof LinearScanQuery) {
            throw new AbortException("Expected an accelerated query, but got a linear scan -- index is not used.");
        }
        KNNQuery<Object> kNNQuery2 = this.forcelinear ? QueryUtil.getLinearScanKNNQuery(distanceQuery) : database.getKNNQuery(distanceQuery, this.k, "exact");
        if (kNNQuery.getClass().equals(kNNQuery2.getClass())) {
            LOG.warning("Query classes are the same. This experiment may be invalid!");
        }
        if (this.queries == null || this.pattern != null) {
            Relation<String> relation2 = this.pattern != null ? DatabaseUtil.guessLabelRepresentation(database) : null;
            DBIDs dBIDs = DBIDUtil.randomSample(relation.getDBIDs(), this.sampling, this.random);
            FiniteProgress finiteProgress = LOG.isVeryVerbose() ? new FiniteProgress("kNN queries", dBIDs.size(), LOG) : null;
            MeanVariance meanVariance = new MeanVariance();
            MeanVariance meanVariance2 = new MeanVariance();
            MeanVariance meanVariance3 = new MeanVariance();
            MeanVariance meanVariance4 = new MeanVariance();
            MeanVariance meanVariance5 = new MeanVariance();
            int n = 0;
            DBIDIter dBIDIter = dBIDs.iter();
            while (dBIDIter.valid()) {
                if (this.pattern == null || this.pattern.matcher(relation2.get(dBIDIter)).find()) {
                    KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.k);
                    KNNList kNNList2 = kNNQuery2.getKNNForDBID(dBIDIter, this.k);
                    meanVariance.put((double)(kNNList.size() * this.k) / (double)kNNList2.size());
                    meanVariance2.put((double)DBIDUtil.intersectionSize(kNNList, kNNList2) / (double)kNNList2.size());
                    if (kNNList.size() >= this.k) {
                        double d = kNNList.getKNNDistance();
                        double d2 = kNNList2.getKNNDistance();
                        if (d2 > 0.0) {
                            meanVariance3.put(d);
                            meanVariance4.put(d - d2);
                            meanVariance5.put(d / d2);
                        }
                    } else {
                        ++n;
                    }
                }
                LOG.incrementProcessed(finiteProgress);
                dBIDIter.advance();
            }
            LOG.ensureCompleted(finiteProgress);
            if (LOG.isStatistics()) {
                LOG.statistics("Mean number of results: " + meanVariance.getMean() + " +- " + meanVariance.getNaiveStddev());
                LOG.statistics("Recall of true results: " + meanVariance2.getMean() + " +- " + meanVariance2.getNaiveStddev());
                if (meanVariance3.getCount() > 0.0) {
                    LOG.statistics("Mean k-distance: " + meanVariance3.getMean() + " +- " + meanVariance3.getNaiveStddev());
                    LOG.statistics("Mean absolute k-error: " + meanVariance4.getMean() + " +- " + meanVariance4.getNaiveStddev());
                    LOG.statistics("Mean relative k-error: " + meanVariance5.getMean() + " +- " + meanVariance5.getNaiveStddev());
                }
                if (n > 0) {
                    LOG.statistics(String.format("Number of queries that returned less than k=%d objects: %d (%.2f%%)", this.k, n, (double)n * 100.0 / meanVariance.getCount()));
                }
            }
        } else {
            TypeInformation typeInformation = this.getDistanceFunction().getInputTypeRestriction();
            MultipleObjectsBundle multipleObjectsBundle = this.queries.loadData();
            int n = -1;
            for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
                if (!typeInformation.isAssignableFromType(multipleObjectsBundle.meta(i))) continue;
                n = i;
                break;
            }
            if (n < 0) {
                throw new AbortException("No compatible data type in query input was found. Expected: " + typeInformation.toString());
            }
            DBIDRange dBIDRange = DBIDUtil.generateStaticDBIDRange(multipleObjectsBundle.dataLength());
            DBIDs dBIDs = DBIDUtil.randomSample((DBIDs)dBIDRange, this.sampling, this.random);
            FiniteProgress finiteProgress = LOG.isVeryVerbose() ? new FiniteProgress("kNN queries", dBIDs.size(), LOG) : null;
            MeanVariance meanVariance = new MeanVariance();
            MeanVariance meanVariance6 = new MeanVariance();
            MeanVariance meanVariance7 = new MeanVariance();
            MeanVariance meanVariance8 = new MeanVariance();
            MeanVariance meanVariance9 = new MeanVariance();
            int n2 = 0;
            DBIDIter dBIDIter = dBIDs.iter();
            while (dBIDIter.valid()) {
                int n3 = dBIDRange.binarySearch(dBIDIter);
                assert (n3 >= 0);
                Object object = multipleObjectsBundle.data(n3, n);
                KNNList kNNList = kNNQuery.getKNNForObject(object, this.k);
                KNNList kNNList3 = kNNQuery2.getKNNForObject(object, this.k);
                meanVariance.put((double)(kNNList.size() * this.k) / (double)kNNList3.size());
                meanVariance6.put((double)DBIDUtil.intersectionSize(kNNList, kNNList3) / (double)kNNList3.size());
                if (kNNList.size() >= this.k) {
                    double d = kNNList.getKNNDistance();
                    double d3 = kNNList3.getKNNDistance();
                    if (d3 > 0.0) {
                        meanVariance7.put(d);
                        meanVariance8.put(d - d3);
                        meanVariance9.put(d / d3);
                    }
                } else {
                    ++n2;
                }
                LOG.incrementProcessed(finiteProgress);
                dBIDIter.advance();
            }
            LOG.ensureCompleted(finiteProgress);
            if (LOG.isStatistics()) {
                LOG.statistics("Mean number of results: " + meanVariance.getMean() + " +- " + meanVariance.getNaiveStddev());
                LOG.statistics("Recall of true results: " + meanVariance6.getMean() + " +- " + meanVariance6.getNaiveStddev());
                if (meanVariance7.getCount() > 0.0) {
                    LOG.statistics("Mean absolute k-error: " + meanVariance8.getMean() + " +- " + meanVariance8.getNaiveStddev());
                    LOG.statistics("Mean relative k-error: " + meanVariance9.getMean() + " +- " + meanVariance9.getNaiveStddev());
                }
                if (n2 > 0) {
                    LOG.statistics(String.format("Number of queries that returned less than k=%d objects: %d (%.2f%%)", this.k, n2, (double)n2 * 100.0 / meanVariance.getCount()));
                }
            }
        }
        return null;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("validateknn.k", "Number of neighbors to retreive for kNN benchmarking.");
        public static final OptionID QUERY_ID = new OptionID("validateknn.query", "Data source for the queries. If not set, the queries are taken from the database.");
        public static final OptionID SAMPLING_ID = new OptionID("validateknn.sampling", "Sampling size parameter. If the value is less or equal 1, it is assumed to be the relative share. Larger values will be interpreted as integer sizes. By default, all data will be used.");
        public static final OptionID FORCE_ID = new OptionID("validateknn.force-linear", "Force the use of linear scanning as reference.");
        public static final OptionID RANDOM_ID = new OptionID("validateknn.random", "Random generator for sampling.");
        public static final OptionID PATTERN_ID = new OptionID("validateknn.pattern", "Pattern to select query points.");
        protected int k = 10;
        protected DatabaseConnection queries = null;
        protected double sampling = -1.0;
        protected boolean forcelinear = false;
        protected RandomFactory random;
        protected Pattern pattern;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            Flag flag;
            AbstractParameter abstractParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(K_ID);
            if (parameterization.grab(intParameter)) {
                this.k = intParameter.intValue();
            }
            PatternParameter patternParameter = new PatternParameter(PATTERN_ID);
            patternParameter.setOptional(true);
            if (parameterization.grab(patternParameter)) {
                this.pattern = (Pattern)patternParameter.getValue();
            } else {
                abstractParameter = new ObjectParameter(QUERY_ID, DatabaseConnection.class);
                abstractParameter.setOptional(true);
                if (parameterization.grab(abstractParameter)) {
                    this.queries = (DatabaseConnection)((ObjectParameter)abstractParameter).instantiateClass(parameterization);
                }
            }
            abstractParameter = new DoubleParameter(SAMPLING_ID);
            abstractParameter.setOptional(true);
            if (parameterization.grab(abstractParameter)) {
                this.sampling = ((DoubleParameter)abstractParameter).doubleValue();
            }
            if (parameterization.grab(flag = new Flag(FORCE_ID))) {
                this.forcelinear = flag.isTrue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(RANDOM_ID, RandomFactory.DEFAULT))) {
                this.random = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected ValidateApproximativeKNNIndex<O> makeInstance() {
            return new ValidateApproximativeKNNIndex(this.distanceFunction, this.k, this.queries, this.sampling, this.forcelinear, this.random, this.pattern);
        }
    }
}

