/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.AbstractNeighborhoodOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Arrays;

@Title(value="A Trimmed Mean Approach to Finding Spatial Outliers")
@Description(value="A local trimmed mean approach to evaluating the spatial outlier factor which is the degree that a site is outlying compared to its neighbors")
@Reference(authors="Tianming Hu and Sam Yuan Sung", title="A trimmed mean approach to finding spatial outliers", booktitle="Intelligent Data Analysis, Volume 8, 2004", url="http://iospress.metapress.com/content/PLVLT6431DVNJXNK")
public class TrimmedMeanApproach<N>
extends AbstractNeighborhoodOutlier<N> {
    private static final Logging LOG = Logging.getLogger(TrimmedMeanApproach.class);
    private double p;

    protected TrimmedMeanApproach(NeighborSetPredicate.Factory<N> factory, double d) {
        super(factory);
        this.p = d;
    }

    public OutlierResult run(Database database, Relation<N> relation, Relation<? extends NumberVector> relation2) {
        assert (RelationUtil.dimensionality(relation2) == 1) : "TrimmedMean can only process one-dimensional data sets.";
        NeighborSetPredicate neighborSetPredicate = this.getNeighborSetPredicateFactory().instantiate(database, relation);
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation2.getDBIDs(), 1);
        WritableDoubleDataStore writableDoubleDataStore2 = DataStoreUtil.makeDoubleStorage(relation2.getDBIDs(), 4);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Computing trimmed means", relation2.size(), LOG) : null;
        DBIDIter dBIDIter = relation2.iterDBIDs();
        while (dBIDIter.valid()) {
            double d;
            DBIDs dBIDs = neighborSetPredicate.getNeighborDBIDs(dBIDIter);
            int n = 0;
            double[] dArray = new double[dBIDs.size()];
            DBIDIter dBIDIter2 = dBIDs.iter();
            while (dBIDIter2.valid()) {
                dArray[n] = relation2.get(dBIDIter2).doubleValue(0);
                ++n;
                dBIDIter2.advance();
            }
            if (n > 0) {
                int n2 = (int)Math.floor(this.p * (double)(n - 1));
                int n3 = (int)Math.floor((1.0 - this.p) * (double)(n - 1));
                Arrays.sort(dArray, 0, n);
                Mean mean = new Mean();
                for (int i = n2; i <= n3; ++i) {
                    mean.put(dArray[i]);
                }
                d = mean.getMean();
            } else {
                d = relation2.get(dBIDIter).doubleValue(0);
            }
            writableDoubleDataStore.putDouble(dBIDIter, relation2.get(dBIDIter).doubleValue(0) - d);
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        if (LOG.isVerbose()) {
            LOG.verbose("Computing median error.");
        }
        Object object = new double[relation2.size()];
        int n = 0;
        DBIDIter dBIDIter3 = relation2.iterDBIDs();
        while (dBIDIter3.valid()) {
            object[n] = writableDoubleDataStore.doubleValue(dBIDIter3);
            ++n;
            dBIDIter3.advance();
        }
        double d = QuickSelect.median((double[])object);
        for (int i = 0; i < ((double[])object).length; ++i) {
            object[i] = Math.abs(object[i] - d);
        }
        double d2 = QuickSelect.median((double[])object);
        if (LOG.isVerbose()) {
            LOG.verbose("Normalizing scores.");
        }
        object = new DoubleMinMax();
        Object object2 = relation2.iterDBIDs();
        while (object2.valid()) {
            double d3 = Math.abs(writableDoubleDataStore.doubleValue((DBIDRef)object2)) * 0.6745 / d2;
            writableDoubleDataStore2.putDouble((DBIDRef)object2, d3);
            ((DoubleMinMax)object).put(d3);
            object2.advance();
        }
        object2 = new MaterializedDoubleRelation("TrimmedMean", "Trimmed Mean Score", writableDoubleDataStore2, relation2.getDBIDs());
        BasicOutlierScoreMeta basicOutlierScoreMeta = new BasicOutlierScoreMeta(((DoubleMinMax)object).getMin(), ((DoubleMinMax)object).getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        OutlierResult outlierResult = new OutlierResult(basicOutlierScoreMeta, (DoubleRelation)object2);
        outlierResult.addChildResult(neighborSetPredicate);
        return outlierResult;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD_1D);
    }

    public static class Parameterizer<N>
    extends AbstractNeighborhoodOutlier.Parameterizer<N> {
        public static final OptionID P_ID = new OptionID("tma.p", "the percentile parameter");
        protected double p = 0.2;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(P_ID);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            doubleParameter.addConstraint(CommonConstraints.LESS_THAN_HALF_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.p = (Double)doubleParameter.getValue();
            }
        }

        @Override
        protected TrimmedMeanApproach<N> makeInstance() {
            return new TrimmedMeanApproach(this.npredf, this.p);
        }
    }
}

