/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.classification.holdout;

import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.evaluation.classification.holdout.RandomizedHoldout;
import de.lmu.ifi.dbs.elki.evaluation.classification.holdout.TrainingAndTestSet;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;
import java.util.Random;

public class DisjointCrossValidation
extends RandomizedHoldout {
    protected int nfold;
    protected int fold;
    protected int[] assignment;
    protected int[] sizes;

    public DisjointCrossValidation(RandomFactory randomFactory, int n) {
        super(randomFactory);
        this.nfold = n;
    }

    @Override
    public void initialize(MultipleObjectsBundle multipleObjectsBundle) {
        super.initialize(multipleObjectsBundle);
        this.fold = 0;
        Random random = this.random.getSingleThreadedRandom();
        this.sizes = new int[this.nfold];
        this.assignment = new int[multipleObjectsBundle.dataLength()];
        for (int i = 0; i < this.assignment.length; ++i) {
            int n;
            this.assignment[i] = n = random.nextInt(this.nfold);
            int n2 = n;
            this.sizes[n2] = this.sizes[n2] + 1;
        }
    }

    @Override
    public int numberOfPartitions() {
        return this.nfold;
    }

    @Override
    public TrainingAndTestSet nextPartitioning() {
        if (this.fold >= this.nfold) {
            return null;
        }
        int n = this.sizes[this.fold];
        int n2 = this.bundle.dataLength() - n;
        MultipleObjectsBundle multipleObjectsBundle = new MultipleObjectsBundle();
        MultipleObjectsBundle multipleObjectsBundle2 = new MultipleObjectsBundle();
        int n3 = this.bundle.metaLength();
        for (int i = 0; i < n3; ++i) {
            ArrayList<Object> arrayList = new ArrayList<Object>(n2);
            ArrayList arrayList2 = new ArrayList(n);
            for (int j = 0; j < this.bundle.dataLength(); ++j) {
                (this.assignment[j] != this.fold ? arrayList : arrayList2).add(this.bundle.data(j, i));
            }
            multipleObjectsBundle.appendColumn(this.bundle.meta(i), arrayList);
            multipleObjectsBundle2.appendColumn(this.bundle.meta(i), arrayList2);
        }
        ++this.fold;
        return new TrainingAndTestSet(multipleObjectsBundle, multipleObjectsBundle2, this.labels);
    }

    public static class Parameterizer
    extends RandomizedHoldout.Parameterizer {
        public static final int N_DEFAULT = 10;
        public static final OptionID NFOLD_ID = new OptionID("nfold", "Number of folds for cross-validation.");
        protected int nfold = 10;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(NFOLD_ID, 10).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.nfold = intParameter.intValue();
            }
        }

        @Override
        protected DisjointCrossValidation makeInstance() {
            return new DisjointCrossValidation(this.random, this.nfold);
        }
    }
}

