/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui;

import de.lmu.ifi.dbs.elki.logging.Logging;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import javax.swing.UIManager;

public final class GUIUtil {
    public static final boolean THREAD_REPAINT_DEBUG = false;
    public static final boolean PREFER_GTK = true;

    private GUIUtil() {
    }

    public static void setLookAndFeel() {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Class<?> clazz = Class.forName("sun.awt.SunToolkit");
            Method method = clazz.getMethod("isNativeGTKAvailable", new Class[0]);
            if (clazz.isInstance(toolkit) && ((Boolean)method.invoke((Object)toolkit, new Object[0])).booleanValue()) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void logUncaughtExceptions(final Logging logging) {
        try {
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable throwable) {
                    logging.exception(throwable);
                }
            });
        }
        catch (SecurityException securityException) {
            logging.warning("Could not set the Default Uncaught Exception Handler", securityException);
        }
    }
}

