/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierGammaScaling;

@Reference(authors="H.-P. Kriegel, P. Kr\u00f6ger, E. Schubert, A. Zimek", title="Interpreting and Unifying Outlier Scores", booktitle="Proc. 11th SIAM International Conference on Data Mining (SDM), Mesa, AZ, 2011", url="http://dx.doi.org/10.1137/1.9781611972818.2")
public class MinusLogGammaScaling
extends OutlierGammaScaling {
    double max = 0.0;
    double mlogmax;

    public MinusLogGammaScaling() {
        super(false);
    }

    @Override
    protected double preScale(double d) {
        assert (this.max > 0.0) : "prepare() was not run prior to using the scaling function.";
        return -Math.log(d / this.max) / this.mlogmax;
    }

    @Override
    public void prepare(OutlierResult outlierResult) {
        this.meta = outlierResult.getOutlierMeta();
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        DoubleRelation doubleRelation = outlierResult.getScores();
        Object object = doubleRelation.iterDBIDs();
        while (object.valid()) {
            double d = doubleRelation.doubleValue((DBIDRef)object);
            if (!Double.isNaN(d) && !Double.isInfinite(d)) {
                doubleMinMax.put(d);
            }
            object.advance();
        }
        this.max = doubleMinMax.getMax();
        this.mlogmax = -Math.log(doubleMinMax.getMin() / this.max);
        object = new MeanVariance();
        DBIDIter dBIDIter = doubleRelation.iterDBIDs();
        while (dBIDIter.valid()) {
            double d = doubleRelation.doubleValue(dBIDIter);
            if (!Double.isNaN(d = this.preScale(d)) && !Double.isInfinite(d)) {
                ((MeanVariance)object).put(d);
            }
            dBIDIter.advance();
        }
        double d = ((MeanVariance)object).getMean();
        double d2 = ((MeanVariance)object).getSampleVariance();
        this.k = d * d / d2;
        this.theta = d2 / d;
        this.atmean = GammaDistribution.regularizedGammaP(this.k, d / this.theta);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected MinusLogGammaScaling makeInstance() {
            return new MinusLogGammaScaling();
        }
    }
}

