/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.function.Pop;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class Push
extends CommandGene
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.13 $";
    private Class m_type;

    public Push(GPConfiguration a_conf, Class a_type) throws InvalidConfigurationException {
        this(a_conf, a_type, 0, 0);
    }

    public Push(GPConfiguration a_conf, Class a_type, int a_subReturnType, int a_subChildType) throws InvalidConfigurationException {
        super(a_conf, 1, CommandGene.VoidClass, a_subReturnType, a_subChildType);
        this.m_type = a_type;
    }

    public String toString() {
        return "push &1";
    }

    public String getName() {
        return "Push";
    }

    public void execute_void(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        int value = c.execute_int(n, 0, args);
        this.pushIt(new Integer(value));
    }

    public int execute_int(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        int value = c.execute_int(n, 0, args);
        this.pushIt(new Integer(value));
        return value;
    }

    public long execute_long(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        long value = c.execute_long(n, 0, args);
        this.pushIt(new Long(value));
        return value;
    }

    public double execute_double(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        double value = c.execute_double(n, 0, args);
        this.pushIt(new Double(value));
        return value;
    }

    public float execute_float(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        float value = c.execute_float(n, 0, args);
        this.pushIt(new Float(value));
        return value;
    }

    public Object execute_object(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        Object value = c.execute_object(n, 0, args);
        this.pushIt(value);
        return value;
    }

    public boolean isAffectGlobalState() {
        return true;
    }

    public boolean isValid(ProgramChromosome a_program) {
        return a_program.getCommandOfClass(0, Pop.class) >= 0;
    }

    protected void pushIt(Object a_value) {
        this.getGPConfiguration().pushToStack(a_value);
    }

    public Class getChildType(IGPProgram a_ind, int a_chromNum) {
        return this.m_type;
    }

    public int compareTo(Object a_other) {
        int result = super.compareTo(a_other);
        if (result != 0) {
            return result;
        }
        Push other = (Push)a_other;
        return new CompareToBuilder().append((Object)this.m_type, (Object)other.m_type).toComparison();
    }

    public boolean equals(Object a_other) {
        try {
            Push other = (Push)a_other;
            return super.equals(a_other) && new EqualsBuilder().append((Object)this.m_type, (Object)other.m_type).isEquals();
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    public Object clone() {
        try {
            Push result = new Push(this.getGPConfiguration(), this.m_type, this.getSubReturnType(), this.getSubChildType(0));
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }
}

