/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class MergeInfrequentNominalValues
extends SimpleBatchFilter
implements UnsupervisedFilter {
    static final long serialVersionUID = 4444337331921333847L;
    protected int m_MinimumFrequency = 2;
    protected Range m_SelectCols = new Range();
    protected int[] m_SelectedAttributes;
    protected boolean[] m_AttToBeModified;
    protected int[][] m_NewValues;

    @Override
    public String globalInfo() {
        return "Merges all values of the specified nominal attribute that are sufficiently infrequent.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>(3);
        result.addElement(new Option("\tThe minimum frequency for a value to remain (default: 2).\n", "-N", 1, "-N <int>"));
        result.addElement(new Option("\tSets list of attributes to act on (or its inverse). 'first and 'last' are accepted as well.'\n\tE.g.: first-5,7,9,20-last\n\t(default: 1,2)", "R", 1, "-R <range>"));
        result.addElement(new Option("\tInvert matching sense (i.e. act on all attributes not specified in list)", "V", 0, "-V"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-N");
        result.add("" + this.getMinimumFrequency());
        result.add("-R");
        result.add(this.getAttributeIndices());
        if (this.getInvertSelection()) {
            result.add("-V");
        }
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String minFrequencyString = Utils.getOption('N', options);
        if (minFrequencyString.length() != 0) {
            this.setMinimumFrequency(Integer.parseInt(minFrequencyString));
        } else {
            this.setMinimumFrequency(2);
        }
        String tmpStr = Utils.getOption('R', options);
        if (tmpStr.length() != 0) {
            this.setAttributeIndices(tmpStr);
        } else {
            this.setAttributeIndices("");
        }
        this.setInvertSelection(Utils.getFlag('V', options));
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    public String minimumFrequencyTipText() {
        return "The minimum frequency for a value to remain.";
    }

    public int getMinimumFrequency() {
        return this.m_MinimumFrequency;
    }

    public void setMinimumFrequency(int minF) {
        this.m_MinimumFrequency = minF;
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on (or its inverse). This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public String getAttributeIndices() {
        return this.m_SelectCols.getRanges();
    }

    public void setAttributeIndices(String rangeList) {
        this.m_SelectCols.setRanges(rangeList);
    }

    public void setAttributeIndicesArray(int[] attributes) {
        this.setAttributeIndices(Range.indicesToRangeList(attributes));
    }

    public String invertSelectionTipText() {
        return "Determines whether selected attributes are to be acted on or all other attributes are used instead.";
    }

    public boolean getInvertSelection() {
        return this.m_SelectCols.getInvert();
    }

    public void setInvertSelection(boolean invert) {
        this.m_SelectCols.setInvert(invert);
    }

    @Override
    public boolean allowAccessToFullInputFormat() {
        return true;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) {
        int j;
        Object m_SelectedAttribute;
        Object att;
        int current3;
        this.m_SelectCols.setUpper(inputFormat.numAttributes() - 1);
        this.m_SelectedAttributes = this.m_SelectCols.getSelection();
        int[][] freqs = new int[inputFormat.numAttributes()][];
        int[] nArray = this.m_SelectedAttributes;
        int n = this.m_SelectedAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            int m_SelectedAttribute2;
            current3 = m_SelectedAttribute2 = nArray[n2];
            att = inputFormat.attribute(current3);
            if (current3 != inputFormat.classIndex() && ((Attribute)att).isNominal()) {
                freqs[current3] = new int[((Attribute)att).numValues()];
            }
            ++n2;
        }
        for (Instance inst : inputFormat) {
            att = this.m_SelectedAttributes;
            current3 = this.m_SelectedAttributes.length;
            int n3 = 0;
            while (n3 < current3) {
                m_SelectedAttribute = att[n3];
                Object current2 = m_SelectedAttribute;
                if (current2 != inputFormat.classIndex() && inputFormat.attribute((int)current2).isNominal() && !inst.isMissing((int)current2)) {
                    int[] nArray2 = freqs[current2];
                    int n4 = (int)inst.value((int)current2);
                    nArray2[n4] = nArray2[n4] + 1;
                }
                ++n3;
            }
        }
        int[] numInfrequentValues = new int[inputFormat.numAttributes()];
        int[] current3 = this.m_SelectedAttributes;
        int n5 = this.m_SelectedAttributes.length;
        m_SelectedAttribute = 0;
        while (m_SelectedAttribute < n5) {
            int m_SelectedAttribute3;
            int current4 = m_SelectedAttribute3 = current3[m_SelectedAttribute];
            Attribute att2 = inputFormat.attribute(current4);
            if (current4 != inputFormat.classIndex() && att2.isNominal()) {
                int k = 0;
                while (k < att2.numValues()) {
                    if (this.m_Debug) {
                        System.err.println("Attribute: " + att2.name() + " Value: " + att2.value(k) + " Freq.: " + freqs[current4][k]);
                    }
                    if (freqs[current4][k] < this.m_MinimumFrequency) {
                        int n6 = current4;
                        numInfrequentValues[n6] = numInfrequentValues[n6] + 1;
                    }
                    ++k;
                }
            }
            ++m_SelectedAttribute;
        }
        this.m_AttToBeModified = new boolean[inputFormat.numAttributes()];
        this.m_NewValues = new int[inputFormat.numAttributes()][];
        current3 = this.m_SelectedAttributes;
        n5 = this.m_SelectedAttributes.length;
        m_SelectedAttribute = 0;
        while (m_SelectedAttribute < n5) {
            int m_SelectedAttribute4;
            int current5 = m_SelectedAttribute4 = current3[m_SelectedAttribute];
            Attribute att3 = inputFormat.attribute(current5);
            if (numInfrequentValues[current5] > 1) {
                this.m_AttToBeModified[current5] = true;
                j = 1;
                this.m_NewValues[current5] = new int[att3.numValues()];
                int k = 0;
                while (k < att3.numValues()) {
                    this.m_NewValues[current5][k] = freqs[current5][k] < this.m_MinimumFrequency ? 0 : j++;
                    ++k;
                }
            }
            ++m_SelectedAttribute;
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        int i = 0;
        while (i < inputFormat.numAttributes()) {
            int current6 = i;
            Attribute att4 = inputFormat.attribute(current6);
            if (this.m_AttToBeModified[i]) {
                ArrayList<String> vals = new ArrayList<String>();
                StringBuilder sb = new StringBuilder();
                vals.add("");
                j = 0;
                while (j < att4.numValues()) {
                    if (this.m_NewValues[current6][j] == 0) {
                        if (sb.length() != 0) {
                            sb.append("_or_");
                        }
                        sb.append(att4.value(j));
                    } else {
                        vals.add(att4.value(j));
                    }
                    ++j;
                }
                vals.set(0, sb.toString());
                atts.add(new Attribute(String.valueOf(att4.name()) + "_merged_infrequent_values", vals));
            } else {
                atts.add((Attribute)att4.copy());
            }
            ++i;
        }
        Instances data = new Instances(inputFormat.relationName(), atts, 0);
        data.setClassIndex(inputFormat.classIndex());
        return data;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    protected Instances process(Instances instances) throws Exception {
        Instances result = new Instances(this.getOutputFormat(), instances.numInstances());
        int i = 0;
        while (i < instances.numInstances()) {
            Instance inst = instances.instance(i);
            double[] newData = new double[instances.numAttributes()];
            int j = 0;
            while (j < instances.numAttributes()) {
                newData[j] = this.m_AttToBeModified[j] && !inst.isMissing(j) ? (double)this.m_NewValues[j][(int)inst.value(j)] : inst.value(j);
                ++j;
            }
            DenseInstance instNew = new DenseInstance(1.0, newData);
            instNew.setDataset(result);
            this.copyValues(instNew, false, inst.dataset(), this.getOutputFormat());
            result.add(instNew);
            ++i;
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        MergeInfrequentNominalValues.runFilter(new MergeInfrequentNominalValues(), args);
    }
}

