/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.workflow.tasks.emf;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.epsilon.emc.emf.EmfUtil;
import org.eclipse.epsilon.emf.dt.EmfRegistryManager;
import org.eclipse.epsilon.workflow.tasks.EpsilonTask;

public class RegisterTask
extends EpsilonTask {
    protected File file;
    protected boolean permanently = false;

    @Override
    public void executeImpl() throws BuildException {
        if (!this.file.exists()) {
            this.fail("File " + this.file.getAbsolutePath() + " doesn't exist", null);
        }
        try {
            EmfUtil.register(URI.createFileURI(this.file.getAbsolutePath()), EPackage.Registry.INSTANCE);
            if (this.permanently) {
                java.net.URI location = this.file.toURI();
                IFile[] workspaceFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(location);
                if (workspaceFiles.length == 0) {
                    this.fail("File " + this.file.getAbsolutePath() + " is not available in the current workspace", null);
                } else {
                    EmfRegistryManager.getInstance().addMetamodel(workspaceFiles[0].getFullPath().toString());
                }
            }
        }
        catch (Exception e) {
            this.fail(e.getMessage(), e);
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean isPermanently() {
        return this.permanently;
    }

    public void setPermanently(boolean permanently) {
        this.permanently = permanently;
    }
}

