/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.type;

import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.type.FieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;

public class VectorFieldTypeInformation<V extends FeatureVector<?>>
extends VectorTypeInformation<V>
implements FieldTypeInformation {
    private String[] labels = null;

    public static <V extends FeatureVector<?>> VectorFieldTypeInformation<V> typeRequest(Class<? super V> clazz) {
        return new VectorFieldTypeInformation<V>(clazz, -1, Integer.MAX_VALUE);
    }

    public static <V extends FeatureVector<?>> VectorFieldTypeInformation<V> typeRequest(Class<? super V> clazz, int n, int n2) {
        return new VectorFieldTypeInformation<V>(clazz, n, n2);
    }

    public VectorFieldTypeInformation(FeatureVector.Factory<V, ?> factory, int n, String[] stringArray, ByteBufferSerializer<? super V> byteBufferSerializer) {
        super(factory, byteBufferSerializer, n, n);
        this.labels = stringArray;
        assert (stringArray == null || stringArray.length == n) : "Created vector field with incomplete labels.";
    }

    public VectorFieldTypeInformation(FeatureVector.Factory<V, ?> factory, int n, int n2, ByteBufferSerializer<? super V> byteBufferSerializer) {
        super(factory, byteBufferSerializer, n, n2);
    }

    public VectorFieldTypeInformation(FeatureVector.Factory<V, ?> factory, int n, ByteBufferSerializer<? super V> byteBufferSerializer) {
        super(factory, byteBufferSerializer, n, n);
    }

    public VectorFieldTypeInformation(FeatureVector.Factory<V, ?> factory, int n, String[] stringArray) {
        super(factory, factory.getDefaultSerializer(), n, n);
        this.labels = stringArray;
        assert (stringArray == null || stringArray.length == n) : "Created vector field with incomplete labels.";
    }

    private VectorFieldTypeInformation(Class<? super V> clazz, int n, int n2) {
        super(clazz, n, n2);
    }

    public VectorFieldTypeInformation(FeatureVector.Factory<V, ?> factory, int n) {
        super(factory, factory.getDefaultSerializer(), n, n);
    }

    @Override
    public boolean isAssignableFromType(TypeInformation typeInformation) {
        if (this == typeInformation) {
            return true;
        }
        if (!super.isAssignableFromType(typeInformation)) {
            return false;
        }
        VectorTypeInformation vectorTypeInformation = (VectorTypeInformation)typeInformation;
        return vectorTypeInformation.mindim == vectorTypeInformation.maxdim;
    }

    @Override
    public int getDimensionality() {
        if (this.mindim != this.maxdim) {
            throw new UnsupportedOperationException("Requesting dimensionality for a type request without defined dimensionality!");
        }
        return this.mindim;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getRestrictionClass().getSimpleName());
        if (this.mindim == this.maxdim) {
            stringBuilder.append(",dim=").append(this.mindim);
        } else {
            stringBuilder.append(",field");
            if (this.mindim >= 0) {
                stringBuilder.append(",mindim=").append(this.mindim);
            }
            if (this.maxdim < Integer.MAX_VALUE) {
                stringBuilder.append(",maxdim=").append(this.maxdim);
            }
        }
        return stringBuilder.toString();
    }

    public String getLabel(int n) {
        if (this.labels == null) {
            return null;
        }
        return this.labels[n];
    }

    protected String[] getLabels() {
        return this.labels;
    }
}

