/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.AbstractDatabase;
import de.lmu.ifi.dbs.elki.database.UpdatableDatabase;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDFactory;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DBIDView;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedRelation;
import de.lmu.ifi.dbs.elki.database.relation.ModifiableRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.datasource.DatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.FileBasedDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.bundle.ObjectBundle;
import de.lmu.ifi.dbs.elki.datasource.bundle.SingleObjectBundle;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.Collection;

@Description(value="Database using an in-memory hashtable and at least providing linear scans.")
public class HashmapDatabase
extends AbstractDatabase
implements UpdatableDatabase {
    private static final Logging LOG = Logging.getLogger(HashmapDatabase.class);
    private HashSetModifiableDBIDs ids;
    private final DBIDView idrep;
    protected DatabaseConnection databaseConnection;

    public HashmapDatabase(DatabaseConnection databaseConnection, Collection<IndexFactory<?, ?>> collection) {
        this.databaseConnection = databaseConnection;
        this.ids = DBIDUtil.newHashSet();
        this.idrep = new DBIDView(this.ids);
        this.relations.add(this.idrep);
        this.addChildResult(this.idrep);
        if (collection != null) {
            this.indexFactories.addAll(collection);
        }
    }

    public HashmapDatabase() {
        this(null, null);
    }

    @Override
    public void initialize() {
        if (this.databaseConnection != null) {
            this.insert(this.databaseConnection.loadData());
            this.databaseConnection = null;
        }
    }

    @Override
    public DBIDs insert(ObjectBundle objectBundle) {
        if (objectBundle.dataLength() == 0) {
            return DBIDUtil.EMPTYDBIDS;
        }
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(objectBundle.dataLength());
        Relation<?>[] relationArray = this.alignColumns(objectBundle);
        DBIDVar dBIDVar = DBIDUtil.newVar();
        for (int i = 0; i < objectBundle.dataLength(); ++i) {
            if (!objectBundle.assignDBID(i, dBIDVar)) {
                dBIDVar.set(DBIDUtil.generateSingleDBID());
            }
            if (this.ids.contains(dBIDVar)) {
                throw new AbortException("Duplicate DBID conflict.");
            }
            this.ids.add(dBIDVar);
            for (int j = 0; j < relationArray.length; ++j) {
                if (!(relationArray[j] instanceof ModifiableRelation)) {
                    throw new AbortException("Non-modifiable relations have been added to the database.");
                }
                ModifiableRelation modifiableRelation = (ModifiableRelation)relationArray[j];
                modifiableRelation.insert(dBIDVar, objectBundle.data(i, j));
            }
            arrayModifiableDBIDs.add(dBIDVar);
        }
        this.eventManager.fireObjectsInserted(arrayModifiableDBIDs);
        return arrayModifiableDBIDs;
    }

    protected Relation<?>[] alignColumns(ObjectBundle objectBundle) {
        Relation[] relationArray = new Relation[objectBundle.metaLength()];
        long[] lArray = BitsUtil.zero(this.relations.size());
        for (int i = 0; i < relationArray.length; ++i) {
            SimpleTypeInformation<?> simpleTypeInformation = objectBundle.meta(i);
            int n = BitsUtil.nextClearBit(lArray, 0);
            while (n >= 0 && n < this.relations.size()) {
                Relation relation = (Relation)this.relations.get(n);
                if (relation.getDataTypeInformation().isAssignableFromType(simpleTypeInformation)) {
                    relationArray[i] = relation;
                    BitsUtil.setI(lArray, n);
                    break;
                }
                n = BitsUtil.nextClearBit(lArray, n + 1);
            }
            if (relationArray[i] != null) continue;
            relationArray[i] = this.addNewRelation(simpleTypeInformation);
            BitsUtil.setI(lArray, this.relations.size() - 1);
        }
        return relationArray;
    }

    private Relation<?> addNewRelation(SimpleTypeInformation<?> simpleTypeInformation) {
        SimpleTypeInformation<?> simpleTypeInformation2 = simpleTypeInformation;
        MaterializedRelation materializedRelation = new MaterializedRelation(simpleTypeInformation2, this.ids);
        this.relations.add(materializedRelation);
        this.getHierarchy().add(this, materializedRelation);
        for (IndexFactory indexFactory : this.indexFactories) {
            if (!indexFactory.getInputTypeRestriction().isAssignableFromType(simpleTypeInformation)) continue;
            IndexFactory indexFactory2 = indexFactory;
            MaterializedRelation materializedRelation2 = materializedRelation;
            Object i = indexFactory2.instantiate(materializedRelation2);
            i.initialize();
            this.getHierarchy().add(materializedRelation, (Result)i);
        }
        return materializedRelation;
    }

    @Override
    public MultipleObjectsBundle delete(DBIDs dBIDs) {
        MultipleObjectsBundle multipleObjectsBundle = new MultipleObjectsBundle();
        for (Relation relation : this.relations) {
            ArrayList arrayList = new ArrayList(dBIDs.size());
            DBIDIter dBIDIter = dBIDs.iter();
            while (dBIDIter.valid()) {
                arrayList.add(relation.get(dBIDIter));
                dBIDIter.advance();
            }
            multipleObjectsBundle.appendColumn(relation.getDataTypeInformation(), arrayList);
        }
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            this.doDelete(dBIDIter);
            dBIDIter.advance();
        }
        this.eventManager.fireObjectsRemoved(dBIDs);
        return multipleObjectsBundle;
    }

    @Override
    public SingleObjectBundle delete(DBIDRef dBIDRef) {
        SingleObjectBundle singleObjectBundle = new SingleObjectBundle();
        for (Relation relation : this.relations) {
            singleObjectBundle.append(relation.getDataTypeInformation(), relation.get(dBIDRef));
        }
        this.doDelete(dBIDRef);
        this.eventManager.fireObjectRemoved(dBIDRef);
        return singleObjectBundle;
    }

    private void doDelete(DBIDRef dBIDRef) {
        this.ids.remove(dBIDRef);
        for (Relation relation : this.relations) {
            if (relation == this.idrep) continue;
            if (!(relation instanceof ModifiableRelation)) {
                throw new AbortException("Non-modifiable relations have been added to the database.");
            }
            ((ModifiableRelation)relation).delete(dBIDRef);
        }
        DBIDFactory.FACTORY.deallocateSingleDBID(dBIDRef);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractDatabase.Parameterizer {
        protected DatabaseConnection databaseConnection = null;
        private Collection<IndexFactory<?, ?>> indexFactories;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectListParameter objectListParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(DATABASE_CONNECTION_ID, (Class<?>)DatabaseConnection.class, FileBasedDatabaseConnection.class);
            if (parameterization.grab(objectParameter)) {
                this.databaseConnection = (DatabaseConnection)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(objectListParameter = new ObjectListParameter(INDEX_ID, IndexFactory.class, true))) {
                this.indexFactories = objectListParameter.instantiateClasses(parameterization);
            }
        }

        @Override
        protected HashmapDatabase makeInstance() {
            return new HashmapDatabase(this.databaseConnection, this.indexFactories);
        }
    }
}

