/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.internal;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.NoiseHandling;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.AbstractProgress;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleHeap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleMaxHeap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleMinHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

@Reference(authors="L. J. Hubert and J. R. Levin", title="A general statistical framework for assessing categorical clustering in free recall.", booktitle="Psychological Bulletin, Vol. 83(6)", url="http://dx.doi.org/10.1037/0033-2909.83.6.1072")
public class EvaluateCIndex<O>
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(EvaluateCIndex.class);
    private NoiseHandling noiseOption;
    private DistanceFunction<? super O> distance;
    private String key = EvaluateCIndex.class.getName();

    public EvaluateCIndex(DistanceFunction<? super O> distanceFunction, NoiseHandling noiseHandling) {
        this.distance = distanceFunction;
        this.noiseOption = noiseHandling;
    }

    /*
     * Unable to fully structure code
     */
    public double evaluateClustering(Database var1_1, Relation<? extends O> var2_2, DistanceQuery<O> var3_3, Clustering<?> var4_4) {
        block19: {
            block18: {
                var5_5 = var4_4.getAllClusters();
                var6_6 = 0;
                var7_7 = 0;
                block8: for (Cluster<?> var9_10 : var5_5) {
                    if (var9_10.size() <= 1 || var9_10.isNoise()) {
                        switch (1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[this.noiseOption.ordinal()]) {
                            case 1: {
                                var6_6 += var9_10.size();
                                continue block8;
                            }
                            case 2: {
                                continue block8;
                            }
                        }
                    }
                    var7_7 += var9_10.size() * (var9_10.size() - 1) >>> 1;
                }
                var8_9 = 0.0;
                var10_11 = 0.0;
                var12_12 = 0.0;
                if ((long)var7_7 > (long)var2_2.size() * ((long)var2_2.size() - 1L) >>> 2) break block18;
                var14_13 = new DoubleMinHeap(var7_7);
                var15_15 = new DoubleMaxHeap(var7_7);
                var16_16 = EvaluateCIndex.LOG.isVerbose() != false ? new FiniteProgress("Processing clusters for C-Index", var5_5.size(), EvaluateCIndex.LOG) : null;
                block9: for (var17_17 = 0; var17_17 < var5_5.size(); ++var17_17) {
                    var18_19 = var5_5.get(var17_17);
                    if (var18_19.size() > 1 && !var18_19.isNoise()) ** GOTO lbl-1000
                    switch (1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[this.noiseOption.ordinal()]) {
                        case 1: {
                            EvaluateCIndex.LOG.incrementProcessed((AbstractProgress)var16_16);
                            continue block9;
                        }
                        case 2: {
                            this.processSingleton(var18_19, var2_2, var3_3, var14_13, var15_15, var7_7);
                            EvaluateCIndex.LOG.incrementProcessed((AbstractProgress)var16_16);
                            continue block9;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            var8_9 += this.processCluster(var18_19, var5_5, var17_17, var3_3, var14_13, var15_15, var7_7);
                            EvaluateCIndex.LOG.incrementProcessed((AbstractProgress)var16_16);
                        }
                    }
                }
                EvaluateCIndex.LOG.ensureCompleted((FiniteProgress)var16_16);
                if (!EvaluateCIndex.$assertionsDisabled && var15_15.size() != var7_7) {
                    throw new AssertionError();
                }
                if (!EvaluateCIndex.$assertionsDisabled && var14_13.size() != var7_7) {
                    throw new AssertionError();
                }
                var17_18 = var15_15.unsortedIter();
                while (var17_18.valid()) {
                    var10_11 += var17_18.get();
                    var17_18.advance();
                }
                var17_18 = var14_13.unsortedIter();
                while (var17_18.valid()) {
                    var12_12 += var17_18.get();
                    var17_18.advance();
                }
                if (!EvaluateCIndex.$assertionsDisabled && !(var12_12 >= var10_11)) {
                    throw new AssertionError();
                }
                break block19;
            }
            var12_12 = 0.0;
            var10_11 = 0.0;
            var8_9 = 0.0;
        }
        v0 = var14_14 = var12_12 > var10_11 ? (var8_9 - var10_11) / (var12_12 - var10_11) : 0.0;
        if (EvaluateCIndex.LOG.isStatistics()) {
            EvaluateCIndex.LOG.statistics(new StringStatistic(this.key + ".c-index.noise-handling", this.noiseOption.toString()));
            if (var6_6 > 0) {
                EvaluateCIndex.LOG.statistics(new LongStatistic(this.key + ".c-index.ignored", var6_6));
            }
            EvaluateCIndex.LOG.statistics(new DoubleStatistic(this.key + ".c-index", var14_14));
        }
        var16_16 = EvaluationResult.findOrCreate(var1_1.getHierarchy(), var4_4, "Internal Clustering Evaluation", "internal evaluation");
        var17_18 = var16_16.findOrCreateGroup("Distance-based Evaluation");
        var17_18.addMeasure("C-Index", var14_14, 0.0, 1.0, 0.0, true);
        var1_1.getHierarchy().resultChanged((Result)var16_16);
        return var14_14;
    }

    /*
     * Unable to fully structure code
     */
    protected double processCluster(Cluster<?> var1_1, List<? extends Cluster<?>> var2_2, int var3_3, DistanceQuery<O> var4_4, DoubleHeap var5_5, DoubleHeap var6_6, int var7_7) {
        var8_8 = 0.0;
        var10_9 = var1_1.getIDs().iter();
        while (var10_9.valid()) {
            block5: for (var11_10 = var3_3; var11_10 < var2_2.size(); ++var11_10) {
                var12_11 = var2_2.get(var11_10);
                if (var12_11.size() > 1 && !var12_11.isNoise()) ** GOTO lbl-1000
                switch (1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[this.noiseOption.ordinal()]) {
                    case 1: {
                        continue block5;
                    }
                    ** case 2:
lbl11:
                    // 2 sources

                    default: lbl-1000:
                    // 2 sources

                    {
                        var13_12 = var12_11.getIDs().iter();
                        while (var13_12.valid()) {
                            if (DBIDUtil.compare(var10_9, var13_12) > 0) {
                                var14_13 = var4_4.distance((DBIDRef)var10_9, (DBIDRef)var13_12);
                                var6_6.add(var14_13, var7_7);
                                var5_5.add(var14_13, var7_7);
                                if (var12_11 == var1_1) {
                                    var8_8 += var14_13;
                                }
                            }
                            var13_12.advance();
                        }
                        break block0;
                    }
                }
            }
            var10_9.advance();
        }
        return var8_8;
    }

    protected void processSingleton(Cluster<?> cluster, Relation<? extends O> relation, DistanceQuery<O> distanceQuery, DoubleHeap doubleHeap, DoubleHeap doubleHeap2, int n) {
        DBIDIter dBIDIter = cluster.getIDs().iter();
        while (dBIDIter.valid()) {
            DBIDIter dBIDIter2 = relation.iterDBIDs();
            while (dBIDIter2.valid()) {
                if (DBIDUtil.compare(dBIDIter, dBIDIter2) > 0) {
                    double d = distanceQuery.distance((DBIDRef)dBIDIter, (DBIDRef)dBIDIter2);
                    doubleHeap2.add(d, n);
                    doubleHeap.add(d, n);
                }
                dBIDIter2.advance();
            }
            dBIDIter.advance();
        }
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        List<Clustering<? extends Model>> list = ResultUtil.getClusteringResults(result);
        if (list.size() < 1) {
            return;
        }
        Database database = ResultUtil.findDatabase(resultHierarchy);
        Relation relation = database.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        DistanceQuery<? super O> distanceQuery = database.getDistanceQuery(relation, this.distance, new Object[0]);
        for (Clustering<? extends Model> clustering : list) {
            this.evaluateClustering(database, relation, distanceQuery, clustering);
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling;

        static {
            $SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling = new int[NoiseHandling.values().length];
            try {
                1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[NoiseHandling.IGNORE_NOISE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[NoiseHandling.TREAT_NOISE_AS_SINGLETONS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[NoiseHandling.MERGE_NOISE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("c-index.distance", "Distance function to use for computing the c-index.");
        public static final OptionID NOISE_ID = new OptionID("c-index.noisehandling", "Control how noise should be treated.");
        private DistanceFunction<? super O> distance;
        private NoiseHandling noiseOption;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            EnumParameter<NoiseHandling> enumParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(DISTANCE_ID, (Class<?>)DistanceFunction.class, EuclideanDistanceFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.distance = (DistanceFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(enumParameter = new EnumParameter<NoiseHandling>(NOISE_ID, NoiseHandling.class, NoiseHandling.TREAT_NOISE_AS_SINGLETONS))) {
                this.noiseOption = (NoiseHandling)((Object)enumParameter.getValue());
            }
        }

        @Override
        protected EvaluateCIndex<O> makeInstance() {
            return new EvaluateCIndex<O>(this.distance, this.noiseOption);
        }
    }
}

