/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

public class GeneralizedExtremeValueDistribution
extends AbstractDistribution {
    final double mu;
    final double sigma;
    final double k;

    public GeneralizedExtremeValueDistribution(double d, double d2, double d3) {
        this(d, d2, d3, (Random)null);
    }

    public GeneralizedExtremeValueDistribution(double d, double d2, double d3, RandomFactory randomFactory) {
        super(randomFactory);
        this.mu = d;
        this.sigma = d2;
        this.k = d3;
    }

    public GeneralizedExtremeValueDistribution(double d, double d2, double d3, Random random) {
        super(random);
        this.mu = d;
        this.sigma = d2;
        this.k = d3;
    }

    public static double pdf(double d, double d2, double d3, double d4) {
        d = (d - d2) / d3;
        if (d4 > 0.0 || d4 < 0.0) {
            if (d4 * d < -1.0) {
                return 0.0;
            }
            double d5 = Math.pow(1.0 + d4 * d, -1.0 / d4);
            return Math.pow(d5, d4 + 1.0) * Math.exp(-d5) / d3;
        }
        return Math.exp(-d - Math.exp(-d)) / d3;
    }

    @Override
    public double pdf(double d) {
        return GeneralizedExtremeValueDistribution.pdf(d, this.mu, this.sigma, this.k);
    }

    public static double cdf(double d, double d2, double d3, double d4) {
        double d5 = (d - d2) / d3;
        if (d4 > 0.0 || d4 < 0.0) {
            if (d4 * d5 <= -1.0) {
                return d4 > 0.0 ? 0.0 : 1.0;
            }
            return Math.exp(-Math.pow(1.0 + d4 * d5, -1.0 / d4));
        }
        return Math.exp(-Math.exp(-d5));
    }

    @Override
    public double cdf(double d) {
        return GeneralizedExtremeValueDistribution.cdf(d, this.mu, this.sigma, this.k);
    }

    public static double quantile(double d, double d2, double d3, double d4) {
        if (d < 0.0 || d > 1.0) {
            return Double.NaN;
        }
        if (d4 > 0.0) {
            return d2 + d3 * Math.max((Math.pow(-Math.log(d), -d4) - 1.0) / d4, -1.0 / d4);
        }
        if (d4 < 0.0) {
            return d2 + d3 * Math.min((Math.pow(-Math.log(d), -d4) - 1.0) / d4, -1.0 / d4);
        }
        return d2 + d3 * Math.log(1.0 / Math.log(1.0 / d));
    }

    @Override
    public double quantile(double d) {
        return GeneralizedExtremeValueDistribution.quantile(d, this.mu, this.sigma, this.k);
    }

    @Override
    public String toString() {
        return "GeneralizedExtremeValueDistribution(sigma=" + this.sigma + ", mu=" + this.mu + ", k=" + this.k + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double mu;
        double sigma;
        double k;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            DoubleParameter doubleParameter2;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter3 = new DoubleParameter(LOCATION_ID);
            if (parameterization.grab(doubleParameter3)) {
                this.mu = doubleParameter3.doubleValue();
            }
            if (parameterization.grab(doubleParameter2 = new DoubleParameter(SCALE_ID))) {
                this.sigma = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(SHAPE_ID))) {
                this.k = doubleParameter.doubleValue();
            }
        }

        @Override
        protected GeneralizedExtremeValueDistribution makeInstance() {
            return new GeneralizedExtremeValueDistribution(this.mu, this.sigma, this.k, this.rnd);
        }
    }
}

