/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.visualization.svg.UpdateSynchronizer;
import java.util.concurrent.ConcurrentLinkedQueue;

public class UpdateRunner {
    private Object sync;
    private final ConcurrentLinkedQueue<Runnable> queue = new ConcurrentLinkedQueue();
    private UpdateSynchronizer synchronizer = null;

    protected UpdateRunner(Object object) {
        this.sync = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable runnable) {
        this.queue.add(runnable);
        UpdateRunner updateRunner = this;
        synchronized (updateRunner) {
            if (this.synchronizer == null) {
                this.runQueue();
            } else {
                this.synchronizer.activate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runQueue() {
        Object object = this.sync;
        synchronized (object) {
            while (!this.queue.isEmpty()) {
                Runnable runnable = this.queue.poll();
                if (runnable != null) {
                    try {
                        runnable.run();
                    }
                    catch (Exception exception) {
                        LoggingUtil.exception(exception);
                    }
                    continue;
                }
                LoggingUtil.warning("Tried to run a 'null' Object.");
            }
            return;
        }
    }

    public synchronized void clear() {
        this.queue.clear();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public synchronized void synchronizeWith(UpdateSynchronizer updateSynchronizer) {
        if (this.synchronizer == updateSynchronizer) {
            LoggingUtil.warning("Double-synced to the same plot!", new Throwable());
            return;
        }
        if (this.synchronizer != null) {
            LoggingUtil.warning("Attempting to synchronize to more than one synchronizer.");
            return;
        }
        this.synchronizer = updateSynchronizer;
        updateSynchronizer.addUpdateRunner(this);
    }

    public synchronized void unsynchronizeWith(UpdateSynchronizer updateSynchronizer) {
        if (this.synchronizer == null) {
            LoggingUtil.warning("Warning: was not synchronized.");
            return;
        }
        if (this.synchronizer != updateSynchronizer) {
            LoggingUtil.warning("Warning: was synchronized differently!");
            return;
        }
        this.synchronizer = null;
        this.runQueue();
    }
}

