/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.AbstractNumberVector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.DoubleArray;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class DoubleVector
extends AbstractNumberVector {
    public static final Factory FACTORY = new Factory();
    public static final ByteBufferSerializer<DoubleVector> BYTE_SERIALIZER = new SmallSerializer();
    public static final ByteBufferSerializer<DoubleVector> SHORT_SERIALIZER = new ShortSerializer();
    public static final ByteBufferSerializer<DoubleVector> VARIABLE_SERIALIZER = new VariableSerializer();
    private final double[] values;

    private DoubleVector(double[] dArray, boolean bl) {
        this.values = bl ? dArray : (double[])dArray.clone();
    }

    public DoubleVector(double[] dArray) {
        this.values = (double[])dArray.clone();
    }

    public DoubleVector(Vector vector) {
        this.values = vector.getArrayCopy();
    }

    @Override
    public int getDimensionality() {
        return this.values.length;
    }

    @Override
    @Deprecated
    public Double getValue(int n) {
        return this.values[n];
    }

    @Override
    public double doubleValue(int n) {
        return this.values[n];
    }

    @Override
    public long longValue(int n) {
        return (long)this.values[n];
    }

    public double[] getValues() {
        return (double[])this.values.clone();
    }

    @Override
    public Vector getColumnVector() {
        return new Vector((double[])this.values.clone());
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.values.length; ++i) {
            stringBuilder.append(this.values[i]);
            if (i + 1 >= this.values.length) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static class VariableSerializer
    implements ByteBufferSerializer<DoubleVector> {
        @Override
        public DoubleVector fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int n = ByteArrayUtil.readUnsignedVarint(byteBuffer);
            assert (byteBuffer.remaining() >= 8 * n) : "Not enough data remaining in buffer to read " + n + " doubles";
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = byteBuffer.getDouble();
            }
            return new DoubleVector(dArray, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, DoubleVector doubleVector) throws IOException {
            assert (byteBuffer.remaining() >= 8 * doubleVector.values.length) : "Not enough space remaining in buffer to write " + DoubleVector.access$100(doubleVector).length + " doubles";
            ByteArrayUtil.writeUnsignedVarint(byteBuffer, doubleVector.values.length);
            for (int i = 0; i < doubleVector.values.length; ++i) {
                byteBuffer.putDouble(doubleVector.values[i]);
            }
        }

        @Override
        public int getByteSize(DoubleVector doubleVector) {
            return ByteArrayUtil.getUnsignedVarintSize(doubleVector.values.length) + 8 * doubleVector.values.length;
        }
    }

    public static class ShortSerializer
    implements ByteBufferSerializer<DoubleVector> {
        @Override
        public DoubleVector fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.getShort();
            assert (byteBuffer.remaining() >= 8 * n) : "Not enough data remaining in buffer to read " + n + " doubles";
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = byteBuffer.getDouble();
            }
            return new DoubleVector(dArray, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, DoubleVector doubleVector) throws IOException {
            assert (doubleVector.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            assert (byteBuffer.remaining() >= 8 * doubleVector.values.length) : "Not enough space remaining in buffer to write " + DoubleVector.access$100(doubleVector).length + " doubles";
            byteBuffer.putShort((short)doubleVector.values.length);
            for (int i = 0; i < doubleVector.values.length; ++i) {
                byteBuffer.putDouble(doubleVector.values[i]);
            }
        }

        @Override
        public int getByteSize(DoubleVector doubleVector) {
            assert (doubleVector.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            return 2 + 8 * doubleVector.getDimensionality();
        }
    }

    public static class SmallSerializer
    implements ByteBufferSerializer<DoubleVector> {
        @Override
        public DoubleVector fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.get();
            assert (byteBuffer.remaining() >= 8 * n) : "Not enough data remaining in buffer to read " + n + " doubles";
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = byteBuffer.getDouble();
            }
            return new DoubleVector(dArray, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, DoubleVector doubleVector) throws IOException {
            assert (doubleVector.values.length < 127) : "This serializer only supports a maximum dimensionality of 127!";
            assert (byteBuffer.remaining() >= 8 * doubleVector.values.length) : "Not enough space remaining in buffer to write " + DoubleVector.access$100(doubleVector).length + " doubles";
            byteBuffer.put((byte)doubleVector.values.length);
            for (int i = 0; i < doubleVector.values.length; ++i) {
                byteBuffer.putDouble(doubleVector.values[i]);
            }
        }

        @Override
        public int getByteSize(DoubleVector doubleVector) {
            assert (doubleVector.values.length < 127) : "This serializer only supports a maximum dimensionality of 127!";
            return 1 + 8 * doubleVector.getDimensionality();
        }
    }

    public static class Factory
    extends AbstractNumberVector.Factory<DoubleVector> {
        @Override
        public DoubleVector newNumberVector(double[] dArray) {
            return new DoubleVector(dArray);
        }

        @Override
        public <A> DoubleVector newFeatureVector(A a, ArrayAdapter<? extends Number, A> arrayAdapter) {
            int n = arrayAdapter.size(a);
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = arrayAdapter.get(a, i).doubleValue();
            }
            return new DoubleVector(dArray, true);
        }

        @Override
        public <A> DoubleVector newNumberVector(A a, NumberArrayAdapter<?, ? super A> numberArrayAdapter) {
            if (numberArrayAdapter.getClass() == DoubleArray.class) {
                return new DoubleVector(((DoubleArray)a).toArray(), true);
            }
            int n = numberArrayAdapter.size(a);
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = numberArrayAdapter.getDouble(a, i);
            }
            return new DoubleVector(dArray, true);
        }

        @Override
        public ByteBufferSerializer<DoubleVector> getDefaultSerializer() {
            return VARIABLE_SERIALIZER;
        }

        @Override
        public Class<? super DoubleVector> getRestrictionClass() {
            return DoubleVector.class;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            @Override
            protected Factory makeInstance() {
                return FACTORY;
            }
        }
    }
}

