/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics;

import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.KernelDensityFunction;
import java.util.Arrays;

public class KernelDensityEstimator {
    private double[] dens;
    private double[] var;

    public KernelDensityEstimator(double[] dArray, double d, double d2, KernelDensityFunction kernelDensityFunction, int n, double d3) {
        this.process(dArray, d, d2, kernelDensityFunction, n, d3);
    }

    private void process(double[] dArray, double d, double d2, KernelDensityFunction kernelDensityFunction, int n, double d3) {
        this.dens = new double[dArray.length];
        this.var = new double[dArray.length];
        double d4 = (d2 - d) / (double)n * 0.5;
        for (int i = 0; i < dArray.length; ++i) {
            double d5;
            double d6;
            int n2;
            double d7 = 0.0;
            for (n2 = i; n2 >= 0; --n2) {
                d6 = Math.abs(dArray[n2] - dArray[i]) / d4;
                d5 = kernelDensityFunction.density(d6);
                d7 += d5;
                if (d5 < d3) break;
            }
            for (n2 = i + 1; n2 < dArray.length; ++n2) {
                d6 = Math.abs(dArray[n2] - dArray[i]) / d4;
                d5 = kernelDensityFunction.density(d6);
                d7 += d5;
                if (d5 < d3) break;
            }
            double d8 = Math.min(dArray[i] + d4, d2) - Math.max(d, dArray[i] - d4);
            double d9 = d8 / (2.0 * d4);
            this.dens[i] = d7 / ((double)dArray.length * d8 * 0.5);
            this.var[i] = 1.0 / d9;
        }
    }

    public KernelDensityEstimator(double[] dArray, KernelDensityFunction kernelDensityFunction, double d) {
        boolean bl = false;
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i - 1] > dArray[i])) continue;
            bl = true;
            break;
        }
        if (bl) {
            dArray = (double[])dArray.clone();
            Arrays.sort(dArray);
        }
        double d2 = dArray[0];
        double d3 = dArray[dArray.length - 1];
        int n = 1 + (int)Math.log(dArray.length);
        this.process(dArray, d2, d3, kernelDensityFunction, n, d);
    }

    public double[] getDensity() {
        return this.dens;
    }

    public double[] getVariance() {
        return this.var;
    }
}

