/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy;

import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.ModifiableHierarchy;
import java.util.Arrays;
import java.util.HashMap;

public class HashMapHierarchy<O>
implements ModifiableHierarchy<O> {
    private final HashMap<O, Rec<O>> graph;
    Object[] elems = new Object[11];
    int numelems = 0;
    private static final Hierarchy.Iter<?> EMPTY_ITERATOR = new Hierarchy.Iter<Object>(){

        @Override
        public boolean valid() {
            return false;
        }

        @Override
        public Hierarchy.Iter<Object> advance() {
            throw new UnsupportedOperationException("Empty iterators must not be advanced.");
        }

        @Override
        public Object get() {
            throw new UnsupportedOperationException("Iterator is empty.");
        }
    };

    public HashMapHierarchy() {
        this.graph = new HashMap();
    }

    @Override
    public boolean contains(O o) {
        return this.graph.containsKey(o);
    }

    @Override
    public int size() {
        return this.graph.size();
    }

    @Override
    public boolean add(O o, O o2) {
        boolean bl = false;
        Rec<O> rec = this.getRec(o);
        if (rec == null) {
            rec = new Rec();
            this.putRec(o, rec);
        }
        bl |= rec.addChild(o2);
        rec = this.getRec(o2);
        if (rec == null) {
            rec = new Rec();
            this.putRec(o2, rec);
        }
        return bl |= rec.addParent(o);
    }

    @Override
    public boolean add(O o) {
        Rec<O> rec = this.getRec(o);
        if (rec == null) {
            rec = new Rec();
            this.putRec(o, rec);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(O o, O o2) {
        boolean bl = false;
        Rec<O> rec = this.getRec(o);
        if (rec != null) {
            bl |= rec.removeChild(o2);
        }
        if ((rec = this.getRec(o2)) != null) {
            bl |= rec.removeParent(o);
        }
        return bl;
    }

    @Override
    public boolean remove(O o) {
        int n;
        Rec<O> rec = this.getRec(o);
        if (rec == null) {
            return false;
        }
        for (n = 0; n < rec.nump; ++n) {
            this.getRec(rec.parents[n]).removeChild(o);
            rec.parents[n] = null;
        }
        for (n = 0; n < rec.numc; ++n) {
            this.getRec(rec.children[n]).removeParent(o);
            rec.children[n] = null;
        }
        this.removeRec(o);
        return true;
    }

    @Override
    public boolean removeSubtree(O o) {
        int n;
        Rec<O> rec = this.getRec(o);
        if (rec == null) {
            return false;
        }
        for (n = 0; n < rec.nump; ++n) {
            this.getRec(rec.parents[n]).removeChild(o);
            rec.parents[n] = null;
        }
        for (n = 0; n < rec.numc; ++n) {
            Rec<Object> rec2 = this.getRec(rec.children[n]);
            rec2.removeParent(o);
            if (rec2.nump == 0) {
                this.removeSubtree(rec.children[n]);
            }
            rec.children[n] = null;
        }
        this.removeRec(o);
        return true;
    }

    @Override
    public int numChildren(O o) {
        Rec<O> rec = this.getRec(o);
        if (rec == null) {
            return 0;
        }
        return rec.numc;
    }

    @Override
    public Hierarchy.Iter<O> iterChildren(O o) {
        Rec<O> rec = this.getRec(o);
        if (rec == null) {
            return HashMapHierarchy.emptyIterator();
        }
        return rec.iterChildren();
    }

    @Override
    public Hierarchy.Iter<O> iterChildrenReverse(O o) {
        Rec<O> rec = this.getRec(o);
        if (rec == null) {
            return HashMapHierarchy.emptyIterator();
        }
        return rec.iterChildrenReverse();
    }

    @Override
    public Hierarchy.Iter<O> iterDescendants(O o) {
        return new ItrDesc(o);
    }

    @Override
    public Hierarchy.Iter<O> iterDescendantsSelf(O o) {
        return new ItrDesc(o, o);
    }

    @Override
    public int numParents(O o) {
        Rec<O> rec = this.getRec(o);
        if (rec == null) {
            return 0;
        }
        return rec.nump;
    }

    @Override
    public Hierarchy.Iter<O> iterParents(O o) {
        Rec<O> rec = this.getRec(o);
        if (rec == null) {
            return HashMapHierarchy.emptyIterator();
        }
        return rec.iterParents();
    }

    @Override
    public Hierarchy.Iter<O> iterParentsReverse(O o) {
        Rec<O> rec = this.getRec(o);
        if (rec == null) {
            return HashMapHierarchy.emptyIterator();
        }
        return rec.iterParentsReverse();
    }

    @Override
    public Hierarchy.Iter<O> iterAncestors(O o) {
        return new ItrAnc(o);
    }

    @Override
    public Hierarchy.Iter<O> iterAncestorsSelf(O o) {
        return new ItrAnc(o, o);
    }

    @Override
    public Hierarchy.Iter<O> iterAll() {
        return new ItrAll();
    }

    private Rec<O> getRec(O o) {
        return this.graph.get(o);
    }

    private void putRec(O o, Rec<O> rec) {
        this.graph.put(o, rec);
        for (int i = 0; i < this.numelems; ++i) {
            if (o != this.elems[i]) continue;
            return;
        }
        if (this.elems.length == this.numelems) {
            this.elems = Arrays.copyOf(this.elems, (this.elems.length << 1) + 1);
        }
        this.elems[this.numelems++] = o;
    }

    private void removeRec(O o) {
        this.graph.remove(o);
        for (int i = 0; i < this.numelems; ++i) {
            if (o != this.elems[i]) continue;
            System.arraycopy(this.elems, i + 1, this.elems, i, --this.numelems - i);
            this.elems[this.numelems] = null;
            return;
        }
    }

    public static <O> Hierarchy.Iter<O> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    private class ItrAll
    implements Hierarchy.Iter<O> {
        int pos;

        private ItrAll() {
        }

        @Override
        public boolean valid() {
            return this.pos < HashMapHierarchy.this.numelems;
        }

        @Override
        public O get() {
            return HashMapHierarchy.this.elems[this.pos];
        }

        @Override
        public ItrAll advance() {
            ++this.pos;
            return this;
        }
    }

    private class ItrAnc
    implements Hierarchy.Iter<O> {
        final Hierarchy.Iter<O> parentiter;
        Hierarchy.Iter<O> subiter = null;
        O extra = null;

        ItrAnc(O o) {
            this(o, null);
        }

        ItrAnc(O o, O o2) {
            this.parentiter = HashMapHierarchy.this.iterParents(o);
            this.extra = o2;
        }

        @Override
        public boolean valid() {
            return this.extra != null || this.parentiter.valid() || this.subiter != null && this.subiter.valid();
        }

        @Override
        public Hierarchy.Iter<O> advance() {
            if (this.extra != null) {
                this.extra = null;
                return this;
            }
            if (this.subiter == null) {
                assert (this.parentiter.valid());
                this.subiter = HashMapHierarchy.this.iterAncestors(this.parentiter.get());
            } else {
                this.subiter.advance();
            }
            if (this.subiter.valid()) {
                return this;
            }
            this.parentiter.advance();
            this.subiter = null;
            return this;
        }

        @Override
        public O get() {
            if (this.extra != null) {
                return this.extra;
            }
            if (this.subiter != null) {
                assert (this.subiter.valid());
                return this.subiter.get();
            }
            assert (this.parentiter.valid());
            return this.parentiter.get();
        }
    }

    private class ItrDesc
    implements Hierarchy.Iter<O> {
        final Hierarchy.Iter<O> childiter;
        Hierarchy.Iter<O> subiter = null;
        O extra = null;

        ItrDesc(O o) {
            this(o, null);
        }

        ItrDesc(O o, O o2) {
            this.childiter = HashMapHierarchy.this.iterChildren(o);
            this.extra = o2;
        }

        @Override
        public boolean valid() {
            return this.extra != null || this.childiter.valid() || this.subiter != null && this.subiter.valid();
        }

        @Override
        public Hierarchy.Iter<O> advance() {
            if (this.extra != null) {
                this.extra = null;
                return this;
            }
            if (this.subiter == null) {
                assert (this.childiter.valid());
                this.subiter = HashMapHierarchy.this.iterDescendants(this.childiter.get());
            } else {
                this.subiter.advance();
            }
            if (this.subiter.valid()) {
                return this;
            }
            this.childiter.advance();
            this.subiter = null;
            return this;
        }

        @Override
        public O get() {
            if (this.extra != null) {
                return this.extra;
            }
            if (this.subiter != null) {
                assert (this.subiter.valid());
                return this.subiter.get();
            }
            assert (this.childiter.valid());
            return this.childiter.get();
        }
    }

    protected static class Rec<O> {
        int nump = 0;
        int numc = 0;
        Object[] parents = EMPTY;
        Object[] children = EMPTY;
        private static final Object[] EMPTY = new Object[0];

        protected Rec() {
        }

        boolean addParent(O o) {
            int n;
            if (this.parents == EMPTY) {
                this.parents = new Object[1];
                this.parents[0] = o;
                this.nump = 1;
                return true;
            }
            for (n = 0; n < this.nump; ++n) {
                if (!o.equals(this.parents[n])) continue;
                return false;
            }
            if (this.parents.length == this.nump) {
                n = Math.max(5, (this.parents.length << 1) + 1);
                this.parents = Arrays.copyOf(this.parents, n);
            }
            this.parents[this.nump++] = o;
            return true;
        }

        boolean addChild(O o) {
            if (this.children == EMPTY) {
                this.children = new Object[5];
                this.children[0] = o;
                this.numc = 1;
                return true;
            }
            for (int i = 0; i < this.numc; ++i) {
                if (!o.equals(this.children[i])) continue;
                return false;
            }
            if (this.children.length == this.numc) {
                this.children = Arrays.copyOf(this.children, (this.children.length << 1) + 1);
            }
            this.children[this.numc++] = o;
            return true;
        }

        boolean removeParent(O o) {
            if (this.parents == EMPTY) {
                return false;
            }
            for (int i = 0; i < this.nump; ++i) {
                if (!o.equals(this.parents[i])) continue;
                --this.nump;
                System.arraycopy(this.parents, i + 1, this.parents, i, this.nump - i);
                this.parents[this.nump] = null;
                if (this.nump == 0) {
                    this.parents = EMPTY;
                }
                return true;
            }
            return false;
        }

        boolean removeChild(O o) {
            if (this.children == EMPTY) {
                return false;
            }
            for (int i = 0; i < this.numc; ++i) {
                if (!o.equals(this.children[i])) continue;
                --this.numc;
                System.arraycopy(this.children, i + 1, this.children, i, this.numc - i);
                this.children[this.numc] = null;
                if (this.numc == 0) {
                    this.children = EMPTY;
                }
                return true;
            }
            return false;
        }

        public Hierarchy.Iter<O> iterParents() {
            if (this.nump == 0) {
                return EMPTY_ITERATOR;
            }
            return new ItrParents();
        }

        public Hierarchy.Iter<O> iterParentsReverse() {
            if (this.nump == 0) {
                return EMPTY_ITERATOR;
            }
            return new ItrParentsReverse();
        }

        public Hierarchy.Iter<O> iterChildren() {
            if (this.numc == 0) {
                return EMPTY_ITERATOR;
            }
            return new ItrChildren();
        }

        public Hierarchy.Iter<O> iterChildrenReverse() {
            if (this.numc == 0) {
                return EMPTY_ITERATOR;
            }
            return new ItrChildrenReverse();
        }

        class ItrChildrenReverse
        implements Hierarchy.Iter<O> {
            int pos;

            ItrChildrenReverse() {
                this.pos = Rec.this.numc - 1;
            }

            @Override
            public boolean valid() {
                return this.pos >= 0;
            }

            @Override
            public Hierarchy.Iter<O> advance() {
                --this.pos;
                return this;
            }

            @Override
            public O get() {
                return Rec.this.children[this.pos];
            }
        }

        class ItrChildren
        implements Hierarchy.Iter<O> {
            int pos = 0;

            ItrChildren() {
            }

            @Override
            public boolean valid() {
                return this.pos < Rec.this.numc;
            }

            @Override
            public Hierarchy.Iter<O> advance() {
                ++this.pos;
                return this;
            }

            @Override
            public O get() {
                return Rec.this.children[this.pos];
            }
        }

        class ItrParentsReverse
        implements Hierarchy.Iter<O> {
            int pos;

            ItrParentsReverse() {
                this.pos = Rec.this.nump - 1;
            }

            @Override
            public boolean valid() {
                return this.pos >= 0;
            }

            @Override
            public Hierarchy.Iter<O> advance() {
                --this.pos;
                return this;
            }

            @Override
            public O get() {
                return Rec.this.parents[this.pos];
            }
        }

        class ItrParents
        implements Hierarchy.Iter<O> {
            int pos = 0;

            ItrParents() {
            }

            @Override
            public boolean valid() {
                return this.pos < Rec.this.nump;
            }

            @Override
            public Hierarchy.Iter<O> advance() {
                ++this.pos;
                return this;
            }

            @Override
            public O get() {
                return Rec.this.parents[this.pos];
            }
        }
    }
}

