/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.omopso;

import org.uma.jmetal.algorithm.multiobjective.omopso.OMOPSO;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.impl.mutation.NonUniformMutation;
import org.uma.jmetal.operator.impl.mutation.UniformMutation;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.AlgorithmBuilder;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;

public class OMOPSOBuilder
implements AlgorithmBuilder<OMOPSO> {
    protected DoubleProblem problem;
    protected SolutionListEvaluator<DoubleSolution> evaluator;
    private int swarmSize = 100;
    private int archiveSize = 100;
    private int maxIterations = 25000;
    private UniformMutation uniformMutation;
    private NonUniformMutation nonUniformMutation;

    public OMOPSOBuilder(DoubleProblem problem, SolutionListEvaluator<DoubleSolution> evaluator) {
        this.evaluator = evaluator;
        this.problem = problem;
    }

    public OMOPSOBuilder setSwarmSize(int swarmSize) {
        this.swarmSize = swarmSize;
        return this;
    }

    public OMOPSOBuilder setArchiveSize(int archiveSize) {
        this.archiveSize = archiveSize;
        return this;
    }

    public OMOPSOBuilder setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
        return this;
    }

    public OMOPSOBuilder setUniformMutation(MutationOperator<DoubleSolution> uniformMutation) {
        this.uniformMutation = (UniformMutation)uniformMutation;
        return this;
    }

    public OMOPSOBuilder setNonUniformMutation(MutationOperator<DoubleSolution> nonUniformMutation) {
        this.nonUniformMutation = (NonUniformMutation)nonUniformMutation;
        return this;
    }

    public int getArchiveSize() {
        return this.archiveSize;
    }

    public int getSwarmSize() {
        return this.swarmSize;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public UniformMutation getUniformMutation() {
        return this.uniformMutation;
    }

    public NonUniformMutation getNonUniformMutation() {
        return this.nonUniformMutation;
    }

    @Override
    public OMOPSO build() {
        return new OMOPSO(this.problem, this.evaluator, this.swarmSize, this.maxIterations, this.archiveSize, this.uniformMutation, this.nonUniformMutation);
    }
}

