/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.zdt;

import java.util.BitSet;
import org.uma.jmetal.problem.impl.AbstractBinaryProblem;
import org.uma.jmetal.solution.BinarySolution;
import org.uma.jmetal.util.JMetalException;

public class ZDT5
extends AbstractBinaryProblem {
    private int[] bitsPerVariable;

    public ZDT5() {
        this(11);
    }

    public ZDT5(Integer numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(2);
        this.setName("ZDT5");
        this.bitsPerVariable = new int[numberOfVariables.intValue()];
        this.bitsPerVariable[0] = 30;
        for (int var = 1; var < numberOfVariables; ++var) {
            this.bitsPerVariable[var] = 5;
        }
    }

    @Override
    protected int getBitsPerVariable(int index) {
        if (index < 0 || index >= this.getNumberOfVariables()) {
            throw new JMetalException("Index value is incorrect: " + index);
        }
        return this.bitsPerVariable[index];
    }

    @Override
    public void evaluate(BinarySolution solution) {
        double[] f = new double[solution.getNumberOfObjectives()];
        f[0] = 1.0 + this.u((BitSet)solution.getVariableValue(0));
        double g = this.evalG(solution);
        double h = this.evalH(f[0], g);
        f[1] = h * g;
        solution.setObjective(0, f[0]);
        solution.setObjective(1, f[1]);
    }

    public double evalG(BinarySolution solution) {
        double res = 0.0;
        for (int i = 1; i < solution.getNumberOfVariables(); ++i) {
            res += this.evalV(this.u((BitSet)solution.getVariableValue(i)));
        }
        return res;
    }

    public double evalV(double value) {
        if (value < 5.0) {
            return 2.0 + value;
        }
        return 1.0;
    }

    public double evalH(double f, double g) {
        return 1.0 / f;
    }

    private double u(BitSet bitset) {
        return bitset.cardinality();
    }
}

