/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.engine.traceability.fine.trace;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.epsilon.egl.engine.traceability.fine.trace.TextLocation;
import org.eclipse.epsilon.egl.engine.traceability.fine.trace.TraceLink;

public class Trace {
    public final List<TextLocation> locations = new LinkedList<TextLocation>();
    public final Set<TraceLink> traceLinks = new LinkedHashSet<TraceLink>();
    public String destination;

    public Set<TraceLink> getTraceLinks() {
        return this.traceLinks;
    }

    public List<TextLocation> getLocations() {
        return this.locations;
    }

    public Collection<? extends Object> getAllContents() {
        LinkedList<Object> allContents = new LinkedList<Object>();
        allContents.add(this);
        for (TraceLink traceLink : this.traceLinks) {
            allContents.addAll(traceLink.getAllContents());
        }
        for (TextLocation location : this.locations) {
            allContents.addAll(location.getAllContents());
        }
        return allContents;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String attribute) {
        this.destination = attribute;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Trace)) {
            return false;
        }
        Trace other = (Trace)object;
        return this.locations.equals(other.locations) && this.traceLinks.equals(other.traceLinks) && (this.destination == null ? other.destination == null : this.destination.equals(other.destination));
    }

    public int hashCode() {
        return this.locations.hashCode() + this.traceLinks.hashCode() + (this.destination == null ? 0 : this.destination.hashCode());
    }

    public String toString() {
        return "<Trace # of links:" + this.traceLinks.size() + ", # of locations: " + this.locations.size() + " destination:" + this.destination + ">";
    }
}

