/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.MathCommand;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class Switch
extends MathCommand
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.1 $";
    private Class m_type;

    public Switch(GPConfiguration a_conf, Class a_type) throws InvalidConfigurationException {
        super(a_conf, 3, CommandGene.FloatClass);
        this.m_type = a_type;
    }

    public String toString() {
        return "(&1 ? &2 : &3)";
    }

    public String getName() {
        return "Switch";
    }

    public float execute_float(ProgramChromosome c, int n, Object[] args) {
        boolean condition = true;
        try {
            condition = c.execute_boolean(n, 0, args);
        }
        catch (UnsupportedOperationException u) {
            throw new IllegalStateException("Switch: cannot process boolean condition");
        }
        return condition ? c.execute_float(n, 1, args) : c.execute_float(n, 2, args);
    }

    public double execute_double(ProgramChromosome c, int n, Object[] args) {
        boolean condition = true;
        try {
            condition = c.execute_boolean(n, 0, args);
        }
        catch (UnsupportedOperationException u) {
            throw new IllegalStateException("Switch: cannot process boolean condition");
        }
        return condition ? c.execute_double(n, 1, args) : c.execute_double(n, 2, args);
    }

    public boolean execute_boolean(ProgramChromosome c, int n, Object[] args) {
        boolean condition = true;
        try {
            condition = c.execute_boolean(n, 0, args);
        }
        catch (UnsupportedOperationException u) {
            throw new IllegalStateException("Switch: cannot process boolean condition");
        }
        return condition ? c.execute_boolean(n, 1, args) : c.execute_boolean(n, 2, args);
    }

    public int execute_int(ProgramChromosome c, int n, Object[] args) {
        boolean condition = true;
        try {
            condition = c.execute_boolean(n, 0, args);
        }
        catch (UnsupportedOperationException u) {
            throw new IllegalStateException("Switch: cannot process boolean condition");
        }
        return condition ? c.execute_int(n, 1, args) : c.execute_int(n, 2, args);
    }

    public long execute_long(ProgramChromosome c, int n, Object[] args) {
        boolean condition = true;
        try {
            condition = c.execute_boolean(n, 0, args);
        }
        catch (UnsupportedOperationException u) {
            throw new IllegalStateException("Switch: cannot process boolean condition");
        }
        return condition ? c.execute_long(n, 1, args) : c.execute_long(n, 2, args);
    }

    public Object execute_object(ProgramChromosome c, int n, Object[] args) {
        boolean condition = true;
        try {
            condition = c.execute_boolean(n, 0, args);
        }
        catch (UnsupportedOperationException u) {
            throw new IllegalStateException("Switch: cannot process boolean condition");
        }
        return condition ? c.execute_object(n, 1, args) : c.execute_object(n, 2, args);
    }

    public Class getChildType(IGPProgram a_ind, int a_chromNum) {
        if (a_chromNum == 0) {
            return CommandGene.BooleanClass;
        }
        return this.m_type;
    }

    public Object clone() {
        try {
            Switch result = new Switch(this.getGPConfiguration(), this.m_type);
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }

    public boolean equals(Object a_other) {
        if (a_other == null || !(a_other instanceof Switch)) {
            return false;
        }
        if (!super.equals(a_other)) {
            return false;
        }
        Switch other = (Switch)a_other;
        return new EqualsBuilder().append((Object)this.m_type, (Object)other.m_type).isEquals();
    }
}

