/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.AbstractKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Title(value="Compare-Means")
@Reference(authors="S. J. Phillips", title="Acceleration of k-means and related clustering algorithms", booktitle="Proc. 4th Int. Workshop on Algorithm Engineering and Experiments (ALENEX 2002)", url="http://dx.doi.org/10.1007/3-540-45643-0_13")
public class KMeansCompare<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(KMeansCompare.class);
    private static final String KEY = KMeansCompare.class.getName();

    public KMeansCompare(NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction, int n, int n2, KMeansInitialization<? super V> kMeansInitialization) {
        super(numberVectorDistanceFunction, n, n2, kMeansInitialization);
    }

    @Override
    public Clustering<KMeansModel> run(Database database, Relation<V> relation) {
        int n;
        if (relation.size() <= 0) {
            return new Clustering<KMeansModel>("k-Means Clustering", "kmeans-clustering");
        }
        if (LOG.isStatistics()) {
            LOG.statistics(new StringStatistic(KEY + ".initialization", this.initializer.toString()));
        }
        List<Vector> list = this.initializer.chooseInitialMeans(database, relation, this.k, this.getDistanceFunction(), Vector.FACTORY);
        ArrayList<ModifiableDBIDs> arrayList = new ArrayList<ModifiableDBIDs>();
        for (int i = 0; i < this.k; ++i) {
            arrayList.add(DBIDUtil.newHashSet((int)((double)relation.size() * 2.0 / (double)this.k)));
        }
        WritableIntegerDataStore writableIntegerDataStore = DataStoreUtil.makeIntegerStorage(relation.getDBIDs(), 3, -1);
        double[] dArray = new double[this.k];
        double[][] dArray2 = new double[this.k][this.k];
        IndefiniteProgress indefiniteProgress = LOG.isVerbose() ? new IndefiniteProgress("K-Means iteration", LOG) : null;
        DoubleStatistic doubleStatistic = LOG.isStatistics() ? new DoubleStatistic(this.getClass().getName() + ".variance-sum") : null;
        LongStatistic longStatistic = LOG.isStatistics() ? new LongStatistic(KEY + ".distance-computations") : null;
        for (n = 0; this.maxiter <= 0 || n < this.maxiter; ++n) {
            LOG.incrementProcessed(indefiniteProgress);
            this.recomputeSeperation(list, dArray2, longStatistic);
            boolean bl = this.assignToNearestCluster(relation, list, arrayList, writableIntegerDataStore, dArray, dArray2, longStatistic);
            this.logVarstat(doubleStatistic, dArray);
            if (LOG.isStatistics()) {
                LOG.statistics(longStatistic);
            }
            if (!bl) break;
            list = this.means(arrayList, list, relation);
        }
        LOG.setCompleted(indefiniteProgress);
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(KEY + ".iterations", n));
        }
        Clustering<KMeansModel> clustering = new Clustering<KMeansModel>("k-Means Clustering", "kmeans-clustering");
        for (int i = 0; i < arrayList.size(); ++i) {
            DBIDs dBIDs = (DBIDs)arrayList.get(i);
            if (dBIDs.size() == 0) continue;
            KMeansModel kMeansModel = new KMeansModel(list.get(i), dArray[i]);
            clustering.addToplevelCluster(new Cluster<KMeansModel>(dBIDs, kMeansModel));
        }
        return clustering;
    }

    private void recomputeSeperation(List<Vector> list, double[][] dArray, LongStatistic longStatistic) {
        int n = list.size();
        for (int i = 1; i < n; ++i) {
            Vector vector = list.get(i);
            for (int j = 0; j < i; ++j) {
                double d;
                dArray[i][j] = d = this.distanceFunction.distance(vector, list.get(j));
                dArray[j][i] = d;
            }
        }
        if (longStatistic != null) {
            longStatistic.increment(n * (n - 1) >> 1);
        }
    }

    private boolean assignToNearestCluster(Relation<V> relation, List<Vector> list, List<ModifiableDBIDs> list2, WritableIntegerDataStore writableIntegerDataStore, double[] dArray, double[][] dArray2, LongStatistic longStatistic) {
        assert (this.k == list.size());
        long l = 0L;
        boolean bl = false;
        Arrays.fill(dArray, 0.0);
        for (ModifiableDBIDs modifiableDBIDs : list2) {
            modifiableDBIDs.clear();
        }
        DistanceFunction distanceFunction = this.getDistanceFunction();
        double d = distanceFunction instanceof SquaredEuclideanDistanceFunction ? 4.0 : 2.0;
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            int n = writableIntegerDataStore.intValue(dBIDIter);
            int n2 = n >= 0 ? n : 0;
            NumberVector numberVector = (NumberVector)relation.get(dBIDIter);
            double d2 = distanceFunction.distance(numberVector, list.get(n2));
            ++l;
            double d3 = d * d2;
            int n3 = n2;
            for (int i = 0; i < this.k; ++i) {
                if (i == n2 || dArray2[n3][i] >= d3) continue;
                double d4 = distanceFunction.distance(numberVector, list.get(i));
                ++l;
                if (!(d4 < d2)) continue;
                n3 = i;
                d2 = d4;
            }
            int n4 = n3;
            dArray[n4] = dArray[n4] + d2;
            list2.get(n3).add(dBIDIter);
            bl |= writableIntegerDataStore.putInt(dBIDIter, n3) != n3;
            dBIDIter.advance();
        }
        if (longStatistic != null) {
            longStatistic.increment(l);
        }
        return bl;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractKMeans.Parameterizer<V> {
        @Override
        protected Logging getLogger() {
            return LOG;
        }

        @Override
        protected void getParameterDistanceFunction(Parameterization parameterization) {
            super.getParameterDistanceFunction(parameterization);
            if (this.distanceFunction instanceof SquaredEuclideanDistanceFunction) {
                return;
            }
            if (this.distanceFunction != null && !this.distanceFunction.isMetric()) {
                LOG.warning("Compare k-means requires a metric distance, and k-means should only be used with squared Euclidean distance!");
            }
        }

        @Override
        protected KMeansCompare<V> makeInstance() {
            return new KMeansCompare(this.distanceFunction, this.k, this.maxiter, this.initializer);
        }
    }
}

