/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.uncertain;

import de.lmu.ifi.dbs.elki.algorithm.clustering.DBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.NeighborPredicate;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.uncertain.DiscreteUncertainObject;
import de.lmu.ifi.dbs.elki.data.uncertain.UncertainObject;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.Random;

@Title(value="FDBSCAN: Density-based Clustering of Applications with Noise on fuzzy objects")
@Description(value="Algorithm to find density-connected sets in a database consisting of uncertain/fuzzy objects based on the parameters 'minpts', 'epsilon', 'samplesize', and (if used) 'threshold'")
@Reference(authors="Hans-Peter Kriegel and Martin Pfeifle", title="Density-based clustering of uncertain data", booktitle="Proc. 11th ACM Int. Conf. on Knowledge Discovery and Data Mining (KDD'05)", url="http://dx.doi.org/10.1145/1081870.1081955")
public class FDBSCANNeighborPredicate
implements NeighborPredicate {
    protected double epsilon;
    protected int sampleSize;
    protected double threshold;
    protected RandomFactory rand;

    public FDBSCANNeighborPredicate(double d, int n, double d2, RandomFactory randomFactory) {
        this.epsilon = d;
        this.sampleSize = n;
        this.threshold = d2;
        this.rand = randomFactory;
    }

    @Override
    public <T> NeighborPredicate.Instance<T> instantiate(Database database, SimpleTypeInformation<?> simpleTypeInformation) {
        Relation relation = database.getRelation(TypeUtil.UNCERTAIN_OBJECT_FIELD, new Object[0]);
        return new Instance(this.epsilon, this.sampleSize, this.threshold, relation, this.rand);
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return TypeUtil.UNCERTAIN_OBJECT_FIELD;
    }

    @Override
    public SimpleTypeInformation<?>[] getOutputType() {
        return new SimpleTypeInformation[]{TypeUtil.DBIDS};
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID SAMPLE_SIZE_ID = new OptionID("fdbscan.samplesize", "The number of samples to draw from each uncertain object to determine the epsilon-neighborhood.");
        public static final OptionID THRESHOLD_ID = new OptionID("fdbscan.threshold", "The amount of samples that have to be epsilon-close for two objects to be neighbors.");
        public static final OptionID SEED_ID = new OptionID("fdbscan.seed", "Random generator used to draw samples.");
        protected double epsilon;
        protected int sampleSize;
        protected double threshold;
        protected RandomFactory seed;

        @Override
        public void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            DoubleParameter doubleParameter;
            IntParameter intParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = (DoubleParameter)new DoubleParameter(DBSCAN.Parameterizer.EPSILON_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter2)) {
                this.epsilon = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(intParameter = (IntParameter)new IntParameter(SAMPLE_SIZE_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.sampleSize = intParameter.intValue();
            }
            if (parameterization.grab(doubleParameter = (DoubleParameter)((DoubleParameter)new DoubleParameter(THRESHOLD_ID, 0.5).addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint(CommonConstraints.LESS_EQUAL_ONE_DOUBLE))) {
                this.threshold = doubleParameter.doubleValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(SEED_ID))) {
                this.seed = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected FDBSCANNeighborPredicate makeInstance() {
            return new FDBSCANNeighborPredicate(this.epsilon, this.sampleSize, this.threshold, this.seed);
        }
    }

    public static class Instance
    implements NeighborPredicate.Instance<DBIDs> {
        private double epsilon;
        private double epsilonsq;
        private int sampleSize;
        private double threshold;
        private Relation<? extends UncertainObject> relation;
        private Random rand;

        public Instance(double d, int n, double d2, Relation<? extends UncertainObject> relation, RandomFactory randomFactory) {
            this.epsilon = d;
            this.epsilonsq = d * d;
            this.sampleSize = n;
            this.threshold = d2;
            this.relation = relation;
            this.rand = randomFactory.getRandom();
        }

        @Override
        public DBIDs getNeighbors(DBIDRef dBIDRef) {
            UncertainObject uncertainObject = this.relation.get(dBIDRef);
            ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray();
            DBIDIter dBIDIter = this.relation.iterDBIDs();
            while (dBIDIter.valid()) {
                block8: {
                    if (DBIDUtil.equal(dBIDRef, dBIDIter)) {
                        arrayModifiableDBIDs.add(dBIDIter);
                    } else {
                        UncertainObject uncertainObject2 = this.relation.get(dBIDIter);
                        double d = 0.0;
                        double d2 = 0.0;
                        for (int i = 0; i < uncertainObject.getDimensionality(); ++i) {
                            double d3;
                            double d4 = uncertainObject.getMin(i);
                            double d5 = uncertainObject.getMax(i);
                            double d6 = uncertainObject2.getMin(i);
                            double d7 = uncertainObject2.getMax(i);
                            double d8 = d6 > d5 ? d6 - d5 : (d3 = d4 > d7 ? d4 - d7 : 0.0);
                            if (!(d3 > this.epsilon) && !((d += d3 * d3) > this.epsilonsq)) {
                                double d9;
                                double d10 = Math.abs(d4 - d7);
                                double d11 = d10 > (d9 = Math.abs(d6 - d5)) ? d10 : d9;
                                d2 += d11 * d11;
                                continue;
                            }
                            break block8;
                        }
                        if (d2 <= this.epsilonsq) {
                            arrayModifiableDBIDs.add(dBIDIter);
                        } else if (this.checkSamples(uncertainObject, uncertainObject2)) {
                            arrayModifiableDBIDs.add(dBIDIter);
                        }
                    }
                }
                dBIDIter.advance();
            }
            return arrayModifiableDBIDs;
        }

        private boolean checkSamples(UncertainObject uncertainObject, UncertainObject uncertainObject2) {
            SquaredEuclideanDistanceFunction squaredEuclideanDistanceFunction = SquaredEuclideanDistanceFunction.STATIC;
            if (uncertainObject instanceof DiscreteUncertainObject && uncertainObject2 instanceof DiscreteUncertainObject) {
                DiscreteUncertainObject discreteUncertainObject = (DiscreteUncertainObject)uncertainObject;
                DiscreteUncertainObject discreteUncertainObject2 = (DiscreteUncertainObject)uncertainObject2;
                int n = discreteUncertainObject.getNumberSamples();
                int n2 = discreteUncertainObject2.getNumberSamples();
                double d = this.threshold * (double)n * (double)n2;
                int n3 = 0;
                for (int i = 0; i < n; ++i) {
                    DoubleVector doubleVector = discreteUncertainObject.getSample(i);
                    for (int j = 0; j < n2; ++j) {
                        DoubleVector doubleVector2 = discreteUncertainObject2.getSample(j);
                        if (!(squaredEuclideanDistanceFunction.distance(doubleVector2, doubleVector) <= this.epsilonsq) || !((double)(++n3) >= d)) continue;
                        return true;
                    }
                }
                return false;
            }
            double d = this.threshold * (double)this.sampleSize * (double)this.sampleSize;
            int n = 0;
            for (int i = 0; i < this.sampleSize; ++i) {
                DoubleVector doubleVector = uncertainObject.drawSample(this.rand);
                for (int j = 0; j < this.sampleSize; ++j) {
                    DoubleVector doubleVector3 = uncertainObject2.drawSample(this.rand);
                    if (!(squaredEuclideanDistanceFunction.distance(doubleVector3, doubleVector) <= this.epsilonsq) || !((double)(++n) >= d)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public DBIDs getIDs() {
            return this.relation.getDBIDs();
        }

        @Override
        public DBIDIter iterDBIDs(DBIDs dBIDs) {
            return dBIDs.iter();
        }
    }
}

