/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.AbstractDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.index.tree.DirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;

public class MetricalIndexRangeQuery<O>
extends AbstractDistanceRangeQuery<O> {
    protected final AbstractMTree<O, ?, ?, ?> index;

    public MetricalIndexRangeQuery(AbstractMTree<O, ?, ?, ?> abstractMTree, DistanceQuery<O> distanceQuery) {
        super(distanceQuery);
        this.index = abstractMTree;
    }

    private void doRangeQuery(DBID dBID, AbstractMTreeNode<O, ?, ?> abstractMTreeNode, O o, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
        double d2 = 0.0;
        if (dBID != null) {
            d2 = this.distanceQuery.distance(dBID, o);
            this.index.statistics.countDistanceCalculation();
        }
        if (!abstractMTreeNode.isLeaf()) {
            for (int i = 0; i < abstractMTreeNode.getNumEntries(); ++i) {
                double d3;
                MTreeEntry mTreeEntry = (MTreeEntry)abstractMTreeNode.getEntry(i);
                DBID dBID2 = mTreeEntry.getRoutingObjectID();
                double d4 = mTreeEntry.getCoveringRadius();
                double d5 = dBID != null ? mTreeEntry.getParentDistance() : 0.0;
                double d6 = Math.abs(d2 - d5);
                if (!(d6 <= (d3 = d + d4))) continue;
                double d7 = this.distanceQuery.distance(dBID2, o);
                this.index.statistics.countDistanceCalculation();
                if (!(d7 <= d3)) continue;
                AbstractMTreeNode abstractMTreeNode2 = (AbstractMTreeNode)this.index.getNode(((DirectoryEntry)((Object)mTreeEntry)).getPageID().intValue());
                this.doRangeQuery(dBID2, abstractMTreeNode2, o, d, modifiableDoubleDBIDList);
            }
        } else {
            for (int i = 0; i < abstractMTreeNode.getNumEntries(); ++i) {
                MTreeEntry mTreeEntry = (MTreeEntry)abstractMTreeNode.getEntry(i);
                DBID dBID3 = mTreeEntry.getRoutingObjectID();
                double d8 = dBID != null ? mTreeEntry.getParentDistance() : 0.0;
                double d9 = Math.abs(d2 - d8);
                if (!(d9 <= d)) continue;
                double d10 = this.distanceQuery.distance(dBID3, o);
                this.index.statistics.countDistanceCalculation();
                if (!(d10 <= d)) continue;
                modifiableDoubleDBIDList.add(d10, dBID3);
            }
        }
    }

    @Override
    public void getRangeForObject(O o, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
        this.index.statistics.countRangeQuery();
        this.doRangeQuery(null, (AbstractMTreeNode)this.index.getRoot(), o, d, modifiableDoubleDBIDList);
    }
}

