/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.IntegerHeap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.Iter;
import java.util.Arrays;

public class IntegerMinHeap
implements IntegerHeap {
    protected int[] twoheap;
    protected int size;
    private static final int TWO_HEAP_INITIAL_SIZE = 31;

    public IntegerMinHeap() {
        int[] nArray = new int[31];
        this.twoheap = nArray;
    }

    public IntegerMinHeap(int n) {
        int n2 = MathUtil.nextPow2Int(n + 1) - 1;
        int[] nArray = new int[n2];
        this.twoheap = nArray;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.twoheap, 0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void add(int n) {
        int n2 = n;
        if (this.size >= this.twoheap.length) {
            this.twoheap = Arrays.copyOf(this.twoheap, this.twoheap.length + this.twoheap.length + 1);
        }
        int n3 = this.size++;
        this.twoheap[n3] = n2;
        this.heapifyUp(n3, n2);
    }

    @Override
    public void add(int n, int n2) {
        if (this.size < n2) {
            this.add(n);
        } else if (this.twoheap[0] < n) {
            this.replaceTopElement(n);
        }
    }

    @Override
    public int replaceTopElement(int n) {
        int n2 = this.twoheap[0];
        this.heapifyDown(n);
        return n2;
    }

    private void heapifyUp(int n, int n2) {
        int n3;
        int n4;
        while (n > 0 && n2 < (n4 = this.twoheap[n3 = n - 1 >>> 1])) {
            this.twoheap[n] = n4;
            n = n3;
        }
        this.twoheap[n] = n2;
    }

    @Override
    public int poll() {
        int n = this.twoheap[0];
        --this.size;
        if (this.size > 0) {
            int n2 = this.twoheap[this.size];
            this.twoheap[this.size] = 0;
            this.heapifyDown(n2);
        } else {
            this.twoheap[0] = 0;
        }
        return n;
    }

    private void heapifyDown(int n) {
        int n2 = this.size >>> 1;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = (n3 << 1) + 1;
            int n5 = this.twoheap[n4];
            int n6 = n4 + 1;
            if (n6 < this.size && n5 > this.twoheap[n6]) {
                n4 = n6;
                n5 = this.twoheap[n6];
            }
            if (n <= n5) break;
            this.twoheap[n3] = n5;
            n3 = n4;
        }
        this.twoheap[n3] = n;
    }

    @Override
    public int peek() {
        return this.twoheap[0];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(IntegerMinHeap.class.getSimpleName()).append(" [");
        UnsortedIter unsortedIter = new UnsortedIter();
        while (unsortedIter.valid()) {
            stringBuilder.append(unsortedIter.get()).append(',');
            unsortedIter.advance();
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public UnsortedIter unsortedIter() {
        return new UnsortedIter();
    }

    private class UnsortedIter
    implements IntegerHeap.UnsortedIter {
        protected int pos = 0;

        private UnsortedIter() {
        }

        @Override
        public boolean valid() {
            return this.pos < IntegerMinHeap.this.size;
        }

        @Override
        public Iter advance() {
            ++this.pos;
            return this;
        }

        @Override
        public int get() {
            return IntegerMinHeap.this.twoheap[this.pos];
        }
    }
}

