/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;

@Reference(authors="H. V. Nguyen, H. H. Ang, V. Gopalkrishnan", title="Mining Outliers with Ensemble of Heterogeneous Detectors on Random Subspaces", booktitle="Proc. 15th International Conference on Database Systems for Advanced Applications (DASFAA 2010)", url="http://dx.doi.org/10.1007/978-3-642-12026-8_29")
public class HeDESNormalizationOutlierScaling
implements OutlierScalingFunction {
    double mean;
    double stddev;
    double scaledmin;
    double scaledmax;

    @Override
    public void prepare(OutlierResult outlierResult) {
        MeanVariance meanVariance = new MeanVariance();
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        DoubleRelation doubleRelation = outlierResult.getScores();
        DBIDIter dBIDIter = doubleRelation.iterDBIDs();
        while (dBIDIter.valid()) {
            double d = doubleRelation.doubleValue(dBIDIter);
            if (!Double.isNaN(d) && !Double.isInfinite(d)) {
                meanVariance.put(d);
                doubleMinMax.put(d);
            }
            dBIDIter.advance();
        }
        this.mean = meanVariance.getMean();
        this.stddev = meanVariance.getSampleStddev();
        this.scaledmax = this.getScaled(doubleMinMax.getMax());
        this.scaledmin = this.getScaled(doubleMinMax.getMin());
    }

    @Override
    public <A> void prepare(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        MeanVariance meanVariance = new MeanVariance();
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        int n = numberArrayAdapter.size(a);
        for (int i = 0; i < n; ++i) {
            double d = numberArrayAdapter.getDouble(a, i);
            if (Double.isNaN(d) || Double.isInfinite(d)) continue;
            meanVariance.put(d);
            doubleMinMax.put(d);
        }
        this.mean = meanVariance.getMean();
        this.stddev = meanVariance.getSampleStddev();
        this.scaledmax = this.getScaled(doubleMinMax.getMax());
        this.scaledmin = this.getScaled(doubleMinMax.getMin());
    }

    @Override
    public double getMax() {
        return this.scaledmax;
    }

    @Override
    public double getMin() {
        return this.scaledmin;
    }

    @Override
    public double getScaled(double d) {
        assert (this.stddev > 0.0 || d == this.mean) : "prepare() was not run prior to using the scaling function.";
        if (this.stddev > 0.0) {
            return (d - this.mean) / this.stddev;
        }
        return 0.0;
    }
}

