/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.SLINK;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="D. Defays", title="An Efficient Algorithm for the Complete Link Cluster Method", booktitle="The Computer Journal 20.4", url="http://dx.doi.org/10.1093/comjnl/20.4.364")
@Alias(value={"Defays"})
public class CLINK<O>
extends SLINK<O> {
    private static final Logging LOG = Logging.getLogger(CLINK.class);

    public CLINK(DistanceFunction<? super O> distanceFunction) {
        super(distanceFunction);
    }

    @Override
    protected void process(DBIDRef dBIDRef, ArrayDBIDs arrayDBIDs, DBIDArrayIter dBIDArrayIter, int n, WritableDBIDDataStore writableDBIDDataStore, WritableDoubleDataStore writableDoubleDataStore, WritableDoubleDataStore writableDoubleDataStore2) {
        this.clinkstep3(dBIDRef, dBIDArrayIter, n, writableDBIDDataStore, writableDoubleDataStore, writableDoubleDataStore2);
        this.clinkstep4567(dBIDRef, arrayDBIDs, dBIDArrayIter, n, writableDBIDDataStore, writableDoubleDataStore, writableDoubleDataStore2);
        this.clinkstep8(dBIDRef, dBIDArrayIter, n, writableDBIDDataStore, writableDoubleDataStore, writableDoubleDataStore2);
    }

    private void clinkstep3(DBIDRef dBIDRef, DBIDArrayIter dBIDArrayIter, int n, WritableDBIDDataStore writableDBIDDataStore, WritableDoubleDataStore writableDoubleDataStore, WritableDoubleDataStore writableDoubleDataStore2) {
        DBIDVar dBIDVar = DBIDUtil.newVar();
        dBIDArrayIter.seek(0);
        while (dBIDArrayIter.getOffset() < n) {
            double d;
            double d2 = writableDoubleDataStore.doubleValue(dBIDArrayIter);
            if (d2 < (d = writableDoubleDataStore2.doubleValue(dBIDArrayIter))) {
                dBIDVar.from(writableDBIDDataStore, dBIDArrayIter);
                double d3 = writableDoubleDataStore2.doubleValue(dBIDVar);
                if (d3 < d) {
                    writableDoubleDataStore2.putDouble(dBIDVar, d);
                }
                writableDoubleDataStore2.putDouble(dBIDArrayIter, Double.POSITIVE_INFINITY);
            }
            dBIDArrayIter.advance();
        }
    }

    private void clinkstep4567(DBIDRef dBIDRef, ArrayDBIDs arrayDBIDs, DBIDArrayIter dBIDArrayIter, int n, WritableDBIDDataStore writableDBIDDataStore, WritableDoubleDataStore writableDoubleDataStore, WritableDoubleDataStore writableDoubleDataStore2) {
        double d;
        DBIDArrayIter dBIDArrayIter2 = arrayDBIDs.iter().seek(n - 1);
        DBIDVar dBIDVar = DBIDUtil.newVar();
        dBIDArrayIter.seek(n - 1);
        while (dBIDArrayIter.valid()) {
            double d2;
            d = writableDoubleDataStore.doubleValue(dBIDArrayIter);
            if (d >= (d2 = writableDoubleDataStore2.doubleValue(dBIDVar.from(writableDBIDDataStore, dBIDArrayIter)))) {
                if (writableDoubleDataStore2.doubleValue(dBIDArrayIter) < writableDoubleDataStore2.doubleValue(dBIDArrayIter2)) {
                    dBIDArrayIter2.seek(dBIDArrayIter.getOffset());
                }
            } else {
                writableDoubleDataStore2.putDouble(dBIDArrayIter, Double.POSITIVE_INFINITY);
            }
            dBIDArrayIter.retract();
        }
        dBIDVar = DBIDUtil.newVar().from(writableDBIDDataStore, dBIDArrayIter2);
        d = writableDoubleDataStore.doubleValue(dBIDArrayIter2);
        writableDBIDDataStore.putDBID(dBIDArrayIter2, dBIDRef);
        writableDoubleDataStore.putDouble(dBIDArrayIter2, writableDoubleDataStore2.doubleValue(dBIDArrayIter2));
        if (dBIDArrayIter2.getOffset() < n - 1) {
            DBIDVar dBIDVar2 = DBIDUtil.newVar(dBIDArrayIter.seek(n - 1));
            DBIDVar dBIDVar3 = DBIDUtil.newVar();
            while (!DBIDUtil.equal(dBIDVar, dBIDRef)) {
                if (DBIDUtil.equal(dBIDVar, dBIDVar2)) {
                    writableDBIDDataStore.putDBID(dBIDVar, dBIDRef);
                    writableDoubleDataStore.putDouble(dBIDVar, d);
                    break;
                }
                dBIDVar3.from(writableDBIDDataStore, dBIDVar);
                writableDBIDDataStore.putDBID(dBIDVar, dBIDRef);
                d = writableDoubleDataStore.putDouble(dBIDVar, d);
                dBIDVar.set(dBIDVar3);
            }
        }
    }

    private void clinkstep8(DBIDRef dBIDRef, DBIDArrayIter dBIDArrayIter, int n, WritableDBIDDataStore writableDBIDDataStore, WritableDoubleDataStore writableDoubleDataStore, WritableDoubleDataStore writableDoubleDataStore2) {
        DBIDVar dBIDVar = DBIDUtil.newVar();
        DBIDVar dBIDVar2 = DBIDUtil.newVar();
        dBIDArrayIter.seek(0);
        while (dBIDArrayIter.getOffset() < n) {
            dBIDVar.from(writableDBIDDataStore, dBIDArrayIter);
            dBIDVar2.from(writableDBIDDataStore, dBIDVar);
            if (DBIDUtil.equal(dBIDVar2, dBIDRef) && writableDoubleDataStore.doubleValue(dBIDArrayIter) >= writableDoubleDataStore.doubleValue(dBIDVar)) {
                writableDBIDDataStore.putDBID(dBIDArrayIter, dBIDRef);
            }
            dBIDArrayIter.advance();
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        @Override
        protected CLINK<O> makeInstance() {
            return new CLINK(this.distanceFunction);
        }
    }
}

