/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.anglebased;

import de.lmu.ifi.dbs.elki.algorithm.outlier.anglebased.FastABOD;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel.KernelMatrix;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleMinHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="LB-ABOD: Lower Bounded Angle-Based Outlier Detection")
@Description(value="Outlier detection using variance analysis on angles, especially for high dimensional data sets.")
@Reference(authors="H.-P. Kriegel, M. Schubert, A. Zimek", title="Angle-Based Outlier Detection in High-dimensional Data", booktitle="Proc. 14th ACM SIGKDD Int. Conf. on Knowledge Discovery and Data Mining (KDD '08), Las Vegas, NV, 2008", url="http://dx.doi.org/10.1145/1401890.1401946")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.LBABOD", "lb-abod"})
public class LBABOD<V extends NumberVector>
extends FastABOD<V> {
    private static final Logging LOG = Logging.getLogger(LBABOD.class);
    protected int l;

    public LBABOD(SimilarityFunction<? super V> similarityFunction, int n, int n2) {
        super(similarityFunction, n);
        this.l = n2;
    }

    @Override
    public OutlierResult run(Database database, Relation<V> relation) {
        ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(relation.getDBIDs());
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        DBIDArrayIter dBIDArrayIter2 = arrayDBIDs.iter();
        SimilarityQuery<V> similarityQuery = database.getSimilarityQuery(relation, this.kernelFunction, new Object[0]);
        KernelMatrix kernelMatrix = new KernelMatrix(similarityQuery, relation, (DBIDs)arrayDBIDs);
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(arrayDBIDs, 4);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        double d = 0.0;
        WritableDoubleDataStore writableDoubleDataStore2 = DataStoreUtil.makeDoubleStorage(arrayDBIDs, 3);
        KNNHeap kNNHeap = DBIDUtil.newHeap(this.k);
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList(relation.size());
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            kNNHeap.clear();
            double d8 = kernelMatrix.getSimilarity(dBIDIter, dBIDIter);
            double d9 = 0.0;
            double d10 = 0.0;
            dBIDArrayIter.seek(0);
            while (dBIDArrayIter.valid()) {
                if (!DBIDUtil.equal(dBIDArrayIter, dBIDIter)) {
                    d7 = kernelMatrix.getSimilarity(dBIDArrayIter, dBIDArrayIter);
                    d6 = kernelMatrix.getSimilarity(dBIDIter, dBIDArrayIter);
                    d5 = d8 + d7 - d6 - d6;
                    writableDoubleDataStore2.putDouble(dBIDArrayIter, d5);
                    double d11 = 1.0 / d5;
                    d9 += Math.sqrt(d11);
                    d10 += d11;
                    kNNHeap.insert(d5, dBIDArrayIter);
                }
                dBIDArrayIter.advance();
            }
            d7 = 0.0;
            d6 = 0.0;
            d5 = 0.0;
            KNNList kNNList = kNNHeap.toKNNList();
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            DoubleDBIDListIter doubleDBIDListIter2 = kNNList.iter();
            while (doubleDBIDListIter.valid()) {
                d4 = doubleDBIDListIter.doubleValue();
                d3 = kernelMatrix.getSimilarity(dBIDIter, doubleDBIDListIter);
                if (d4 > 0.0) {
                    doubleDBIDListIter2.seek(doubleDBIDListIter.getOffset() + 1);
                    while (doubleDBIDListIter2.valid()) {
                        d2 = doubleDBIDListIter2.doubleValue();
                        double d12 = kernelMatrix.getSimilarity(dBIDIter, doubleDBIDListIter2);
                        if (d2 > 0.0) {
                            double d13 = kernelMatrix.getSimilarity(doubleDBIDListIter, doubleDBIDListIter2);
                            double d14 = d13 - d3 - d12 + d8;
                            double d15 = 1.0 / (d4 * d2);
                            double d16 = Math.sqrt(d15);
                            double d17 = d14 * d15;
                            d7 += d17 * d16;
                            d6 += d17 * d17 * d16;
                            d5 += d15;
                        }
                        doubleDBIDListIter2.advance();
                    }
                }
                doubleDBIDListIter.advance();
            }
            d4 = d10 * d10 - 2.0 * d5;
            d3 = (2.0 * d7 + d4) / (d9 * d9);
            d2 = 2.0 * d6 / (d9 * d9) - d3 * d3;
            if (d2 > d) {
                d = d2;
            }
            writableDoubleDataStore.putDouble(dBIDIter, d2);
            modifiableDoubleDBIDList.add(d2, dBIDIter);
            dBIDIter.advance();
        }
        doubleMinMax.put(d);
        modifiableDoubleDBIDList.sort();
        int n = 0;
        DoubleMinHeap doubleMinHeap = new DoubleMinHeap(this.l);
        MeanVariance meanVariance = new MeanVariance();
        Object object = modifiableDoubleDBIDList.iter();
        while (object.valid() && (doubleMinHeap.size() < this.k || !(object.doubleValue() > doubleMinHeap.peek()))) {
            double d18 = this.computeABOF(kernelMatrix, (DBIDRef)object, dBIDArrayIter, dBIDArrayIter2, meanVariance);
            writableDoubleDataStore.putDouble((DBIDRef)object, d18);
            doubleMinMax.put(d18);
            if (doubleMinHeap.size() < this.k) {
                doubleMinHeap.add(d18);
            } else if (doubleMinHeap.peek() > d18) {
                doubleMinHeap.replaceTopElement(d18);
            }
            ++n;
            object.advance();
        }
        if (LOG.isStatistics()) {
            LoggingConfiguration.setVerbose(Logging.Level.VERYVERBOSE);
            LOG.statistics(new LongStatistic("lb-abod.refinements", n));
        }
        object = new MaterializedDoubleRelation("Angle-based Outlier Detection", "abod-outlier", writableDoubleDataStore, arrayDBIDs);
        InvertedOutlierScoreMeta invertedOutlierScoreMeta = new InvertedOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY);
        return new OutlierResult(invertedOutlierScoreMeta, (DoubleRelation)object);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends FastABOD.Parameterizer<V> {
        public static final OptionID L_ID = new OptionID("abod.l", "Number of top outliers to compute.");
        protected int l = 0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(L_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.l = (Integer)intParameter.getValue();
            }
        }

        @Override
        protected LBABOD<V> makeInstance() {
            return new LBABOD(this.kernelFunction, this.k, this.l);
        }
    }
}

