/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDKNNList;

public class IntegerDBIDKNNSubList
implements IntegerDBIDKNNList {
    private final int k;
    private final int size;
    private final IntegerDBIDKNNList inner;

    public IntegerDBIDKNNSubList(IntegerDBIDKNNList integerDBIDKNNList, int n) {
        this.inner = integerDBIDKNNList;
        this.k = n;
        if (n < integerDBIDKNNList.getK()) {
            DoubleIntegerDBIDListIter doubleIntegerDBIDListIter = integerDBIDKNNList.iter();
            double d = doubleIntegerDBIDListIter.seek(n - 1).doubleValue();
            int n2 = n;
            doubleIntegerDBIDListIter.advance();
            while (doubleIntegerDBIDListIter.valid() && doubleIntegerDBIDListIter.doubleValue() <= d) {
                ++n2;
                doubleIntegerDBIDListIter.advance();
            }
            this.size = n2;
        } else {
            this.size = integerDBIDKNNList.size();
        }
    }

    @Override
    public int getK() {
        return this.k;
    }

    @Override
    public DoubleIntegerDBIDPair get(int n) {
        assert (n < this.size) : "Access beyond design size of list.";
        return this.inner.get(n);
    }

    @Override
    public double getKNNDistance() {
        return this.inner.get(this.k).doubleValue();
    }

    @Override
    public Itr iter() {
        return new Itr();
    }

    @Override
    public boolean contains(DBIDRef dBIDRef) {
        Itr itr = this.iter();
        while (itr.valid()) {
            if (DBIDUtil.equal(itr, dBIDRef)) {
                return true;
            }
            itr.advance();
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    private class Itr
    implements DoubleIntegerDBIDListIter {
        private int pos = 0;

        private Itr() {
        }

        @Override
        public boolean valid() {
            return this.pos < IntegerDBIDKNNSubList.this.size && this.pos >= 0;
        }

        @Override
        public Itr advance() {
            ++this.pos;
            return this;
        }

        @Override
        public double doubleValue() {
            return IntegerDBIDKNNSubList.this.inner.get(this.pos).doubleValue();
        }

        @Override
        public DoubleDBIDPair getPair() {
            return IntegerDBIDKNNSubList.this.inner.get(this.pos);
        }

        @Override
        public int internalGetIndex() {
            return IntegerDBIDKNNSubList.this.inner.get(this.pos).internalGetIndex();
        }

        @Override
        public int getOffset() {
            return this.pos;
        }

        @Override
        public Itr advance(int n) {
            this.pos += n;
            return this;
        }

        @Override
        public Itr retract() {
            --this.pos;
            return this;
        }

        @Override
        public Itr seek(int n) {
            this.pos = n;
            return this;
        }
    }
}

