/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.range;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.LinearScanQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.AbstractDistanceRangeQuery;

public class LinearScanDistanceRangeQuery<O>
extends AbstractDistanceRangeQuery<O>
implements LinearScanQuery {
    public LinearScanDistanceRangeQuery(DistanceQuery<O> distanceQuery) {
        super(distanceQuery);
    }

    @Override
    public DoubleDBIDList getRangeForDBID(DBIDRef dBIDRef, double d) {
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList();
        DBIDIter dBIDIter = this.relation.getDBIDs().iter();
        while (dBIDIter.valid()) {
            double d2 = this.distanceQuery.distance(dBIDRef, (DBIDRef)dBIDIter);
            if (d2 <= d) {
                modifiableDoubleDBIDList.add(d2, dBIDIter);
            }
            dBIDIter.advance();
        }
        modifiableDoubleDBIDList.sort();
        return modifiableDoubleDBIDList;
    }

    @Override
    public DoubleDBIDList getRangeForObject(O o, double d) {
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList();
        DBIDIter dBIDIter = this.relation.getDBIDs().iter();
        while (dBIDIter.valid()) {
            double d2 = this.distanceQuery.distance(o, dBIDIter);
            if (d2 <= d) {
                modifiableDoubleDBIDList.add(d2, dBIDIter);
            }
            dBIDIter.advance();
        }
        modifiableDoubleDBIDList.sort();
        return modifiableDoubleDBIDList;
    }

    @Override
    public void getRangeForDBID(DBIDRef dBIDRef, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
        DBIDIter dBIDIter = this.relation.iterDBIDs();
        while (dBIDIter.valid()) {
            double d2 = this.distanceQuery.distance(dBIDRef, (DBIDRef)dBIDIter);
            if (d2 <= d) {
                modifiableDoubleDBIDList.add(d2, dBIDIter);
            }
            dBIDIter.advance();
        }
    }

    @Override
    public void getRangeForObject(O o, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
        DBIDIter dBIDIter = this.relation.iterDBIDs();
        while (dBIDIter.valid()) {
            double d2 = this.distanceQuery.distance(o, dBIDIter);
            if (d2 <= d) {
                modifiableDoubleDBIDList.add(d2, dBIDIter);
            }
            dBIDIter.advance();
        }
    }
}

