/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.instancewise;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.AbstractStreamNormalization;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.Arrays;

public class InstanceLogRankNormalization<V extends NumberVector>
extends AbstractStreamNormalization<V> {
    private static final double CENTER = Math.log1p(0.5) * MathUtil.ONE_BY_LOG2;

    @Override
    protected V filterSingleObject(V v) {
        double[] dArray = v.getColumnVector().getArrayRef();
        double[] dArray2 = (double[])dArray.clone();
        Arrays.sort(dArray2);
        double d = 0.5 / (double)(dArray.length - 1);
        for (int i = 0; i < dArray.length; ++i) {
            int n;
            double d2 = dArray[i];
            if (d2 != d2) {
                dArray[i] = CENTER;
                continue;
            }
            int n2 = n + 1;
            assert (n >= 0);
            for (n = Arrays.binarySearch(dArray2, d2); n > 0 && dArray2[n - 1] >= d2; --n) {
            }
            while (n2 < dArray2.length && dArray2[n2] <= d2) {
                ++n2;
            }
            dArray[i] = Math.log1p((double)(n + n2 - 1) * d) * MathUtil.ONE_BY_LOG2;
        }
        return this.factory.newNumberVector(dArray);
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected InstanceLogRankNormalization<NumberVector> makeInstance() {
            return new InstanceLogRankNormalization<NumberVector>();
        }
    }
}

