/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering;

import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.trivial.ByLabelOrAllInOneClustering;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.clustering.BCubed;
import de.lmu.ifi.dbs.elki.evaluation.clustering.ClusterContingencyTable;
import de.lmu.ifi.dbs.elki.evaluation.clustering.EditDistance;
import de.lmu.ifi.dbs.elki.evaluation.clustering.Entropy;
import de.lmu.ifi.dbs.elki.evaluation.clustering.PairCounting;
import de.lmu.ifi.dbs.elki.evaluation.clustering.SetMatchingPurity;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Iterator;
import java.util.List;

@Alias(value={"de.lmu.ifi.dbs.elki.evaluation.paircounting.EvaluatePairCountingFMeasure"})
public class EvaluateClustering
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(EvaluateClustering.class);
    public static final OptionID REFERENCE_ID = new OptionID("paircounting.reference", "Reference clustering to compare with. Defaults to a by-label clustering.");
    public static final OptionID NOISE_ID = new OptionID("paircounting.noisespecial", "Use special handling for noise clusters.");
    public static final OptionID SELFPAIR_ID = new OptionID("paircounting.selfpair", "Enable self-pairing for cluster comparison.");
    private ClusteringAlgorithm<?> referencealg;
    private boolean noiseSpecialHandling;
    private boolean selfPairing;

    public EvaluateClustering(ClusteringAlgorithm<?> clusteringAlgorithm, boolean bl, boolean bl2) {
        this.referencealg = clusteringAlgorithm;
        this.noiseSpecialHandling = bl;
        this.selfPairing = bl2;
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        Clustering clustering;
        if (result instanceof Clustering && this.isReferenceResult((Clustering)result)) {
            return;
        }
        Database database = ResultUtil.findDatabase(resultHierarchy);
        List<Clustering<? extends Model>> list = ResultUtil.getClusteringResults(result);
        if (list == null || list.size() < 1) {
            return;
        }
        Clustering clustering2 = null;
        Object object = ResultUtil.filterResults(resultHierarchy, database, Clustering.class);
        Iterator object22 = object.iterator();
        while (object22.hasNext()) {
            clustering = (Clustering)object22.next();
            if (!this.isReferenceResult(clustering)) continue;
            clustering2 = clustering;
            break;
        }
        if (clustering2 == null) {
            object = ResultUtil.filterResults(resultHierarchy, result, Clustering.class);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                clustering = (Clustering)iterator.next();
                if (!this.isReferenceResult(clustering)) continue;
                clustering2 = clustering;
                break;
            }
        }
        if (clustering2 == null) {
            LOG.debug("Generating a new reference clustering.");
            object = this.referencealg.run(database);
            List<Clustering<? extends Model>> list2 = ResultUtil.getClusteringResults(object);
            if (list2.size() == 0) {
                LOG.warning("Reference algorithm did not return a clustering result!");
                return;
            }
            if (list2.size() > 1) {
                LOG.warning("Reference algorithm returned more than one result!");
            }
            clustering2 = list2.get(0);
        } else {
            LOG.debug("Using existing clustering: " + clustering2.getLongName() + " " + clustering2.getShortName());
        }
        for (Clustering clustering3 : list) {
            if (clustering3 == clustering2) continue;
            this.evaluteResult(database, clustering3, clustering2);
        }
    }

    protected void evaluteResult(Database database, Clustering<?> clustering, Clustering<?> clustering2) {
        ClusterContingencyTable clusterContingencyTable = new ClusterContingencyTable(this.selfPairing, this.noiseSpecialHandling);
        clusterContingencyTable.process(clustering2, clustering);
        ScoreResult scoreResult = new ScoreResult(clusterContingencyTable);
        scoreResult.addHeader(clustering.getLongName());
        database.getHierarchy().add(clustering, scoreResult);
    }

    private boolean isReferenceResult(Clustering<?> clustering) {
        if ("bylabel-clustering".equals(clustering.getShortName())) {
            return true;
        }
        if ("bymodel-clustering".equals(clustering.getShortName())) {
            return true;
        }
        if ("allinone-clustering".equals(clustering.getShortName())) {
            return true;
        }
        return "allinnoise-clustering".equals(clustering.getShortName());
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected ClusteringAlgorithm<?> referencealg = null;
        protected boolean noiseSpecialHandling = false;
        protected boolean selfPairing = false;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            Flag flag2;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(REFERENCE_ID, (Class<?>)ClusteringAlgorithm.class, ByLabelOrAllInOneClustering.class);
            if (parameterization.grab(objectParameter)) {
                this.referencealg = (ClusteringAlgorithm)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(flag2 = new Flag(NOISE_ID))) {
                this.noiseSpecialHandling = (Boolean)flag2.getValue();
            }
            if (parameterization.grab(flag = new Flag(SELFPAIR_ID))) {
                this.selfPairing = (Boolean)flag.getValue();
            }
        }

        @Override
        protected EvaluateClustering makeInstance() {
            return new EvaluateClustering(this.referencealg, this.noiseSpecialHandling, !this.selfPairing);
        }
    }

    public static class ScoreResult
    extends EvaluationResult {
        protected ClusterContingencyTable contmat;

        public ScoreResult(ClusterContingencyTable clusterContingencyTable) {
            super("Cluster-Evalation", "cluster-evaluation");
            this.contmat = clusterContingencyTable;
            PairCounting pairCounting = clusterContingencyTable.getPaircount();
            EvaluationResult.MeasurementGroup measurementGroup = this.newGroup("Pair counting measures");
            measurementGroup.addMeasure("Jaccard", pairCounting.jaccard(), 0.0, 1.0, false);
            measurementGroup.addMeasure("F1-Measure", pairCounting.f1Measure(), 0.0, 1.0, false);
            measurementGroup.addMeasure("Precision", pairCounting.precision(), 0.0, 1.0, false);
            measurementGroup.addMeasure("Recall", pairCounting.recall(), 0.0, 1.0, false);
            measurementGroup.addMeasure("Rand", pairCounting.randIndex(), 0.0, 1.0, false);
            measurementGroup.addMeasure("ARI", pairCounting.adjustedRandIndex(), 0.0, 1.0, false);
            measurementGroup.addMeasure("FowlkesMallows", pairCounting.fowlkesMallows(), 0.0, 1.0, false);
            Entropy entropy = clusterContingencyTable.getEntropy();
            measurementGroup = this.newGroup("Entropy based measures");
            measurementGroup.addMeasure("NMI Joint", entropy.entropyNMIJoint(), 0.0, 1.0, false);
            measurementGroup.addMeasure("NMI Sqrt", entropy.entropyNMISqrt(), 0.0, 1.0, false);
            BCubed bCubed = clusterContingencyTable.getBCubed();
            measurementGroup = this.newGroup("BCubed-based measures");
            measurementGroup.addMeasure("F1-Measure", bCubed.f1Measure(), 0.0, 1.0, false);
            measurementGroup.addMeasure("Recall", bCubed.recall(), 0.0, 1.0, false);
            measurementGroup.addMeasure("Precision", bCubed.precision(), 0.0, 1.0, false);
            SetMatchingPurity setMatchingPurity = clusterContingencyTable.getSetMatching();
            measurementGroup = this.newGroup("Set-Matching-based measures");
            measurementGroup.addMeasure("F1-Measure", setMatchingPurity.f1Measure(), 0.0, 1.0, false);
            measurementGroup.addMeasure("Purity", setMatchingPurity.purity(), 0.0, 1.0, false);
            measurementGroup.addMeasure("Inverse Purity", setMatchingPurity.inversePurity(), 0.0, 1.0, false);
            EditDistance editDistance = clusterContingencyTable.getEdit();
            measurementGroup = this.newGroup("Editing-distance measures");
            measurementGroup.addMeasure("F1-Measure", editDistance.f1Measure(), 0.0, 1.0, false);
            measurementGroup.addMeasure("Precision", editDistance.editDistanceFirst(), 0.0, 1.0, false);
            measurementGroup.addMeasure("Recall", editDistance.editDistanceSecond(), 0.0, 1.0, false);
            MeanVariance meanVariance = clusterContingencyTable.averageSymmetricGini();
            measurementGroup = this.newGroup("Gini measures");
            measurementGroup.addMeasure("Mean +-" + FormatUtil.NF4.format(meanVariance.getCount() > 1.0 ? meanVariance.getSampleStddev() : 0.0), meanVariance.getMean(), 0.0, 1.0, false);
        }

        public ClusterContingencyTable getContingencyTable() {
            return this.contmat;
        }

        @Override
        public boolean visualizeSingleton() {
            return true;
        }
    }
}

