/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.outlier;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.scores.ROCEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.DBIDsTest;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.OutlierScoreAdapter;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.SimpleAdapter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.geometry.XYCurve;
import de.lmu.ifi.dbs.elki.result.OrderingResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterStream;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.List;
import java.util.regex.Pattern;

@Alias(value={"de.lmu.ifi.dbs.elki.evaluation.roc.ComputeROCCurve", "de.lmu.ifi.dbs.elki.evaluation.ComputeROCCurve"})
public class OutlierROCCurve
implements Evaluator {
    public static final String ROCAUC_LABEL = "ROCAUC";
    private static final Logging LOG = Logging.getLogger(OutlierROCCurve.class);
    private Pattern positiveClassName;

    public OutlierROCCurve(Pattern pattern) {
        this.positiveClassName = pattern;
    }

    private ROCResult computeROCResult(int n, SetDBIDs setDBIDs, DBIDs dBIDs) {
        if (dBIDs.size() != n) {
            throw new IllegalStateException("Iterable result doesn't match database size - incomplete ordering?");
        }
        XYCurve xYCurve = ROCEvaluation.materializeROC(new DBIDsTest(setDBIDs), new SimpleAdapter(dBIDs.iter()));
        double d = XYCurve.areaUnderCurve(xYCurve);
        return new ROCResult(xYCurve, d);
    }

    private ROCResult computeROCResult(int n, SetDBIDs setDBIDs, OutlierResult outlierResult) {
        XYCurve xYCurve = ROCEvaluation.materializeROC(new DBIDsTest(setDBIDs), new OutlierScoreAdapter(outlierResult));
        double d = XYCurve.areaUnderCurve(xYCurve);
        return new ROCResult(xYCurve, d);
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        Database database = ResultUtil.findDatabase(resultHierarchy);
        SetDBIDs setDBIDs = DBIDUtil.ensureSet(DatabaseUtil.getObjectsByLabelMatch(database, this.positiveClassName));
        if (setDBIDs.size() == 0) {
            LOG.warning("Computing a ROC curve failed - no objects matched.");
            return;
        }
        boolean bl = true;
        List<OutlierResult> list = ResultUtil.getOutlierResults(result);
        List<OrderingResult> list2 = ResultUtil.getOrderingResults(result);
        for (OutlierResult result2 : list) {
            database.getHierarchy().add(result2, this.computeROCResult(result2.getScores().size(), setDBIDs, result2));
            list2.remove(result2.getOrdering());
            bl = false;
        }
        for (OrderingResult orderingResult : list2) {
            ArrayModifiableDBIDs arrayModifiableDBIDs = orderingResult.order(orderingResult.getDBIDs());
            database.getHierarchy().add(orderingResult, this.computeROCResult(orderingResult.getDBIDs().size(), setDBIDs, arrayModifiableDBIDs));
            bl = false;
        }
        if (bl) {
            return;
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID POSITIVE_CLASS_NAME_ID = new OptionID("rocauc.positive", "Class label for the 'positive' class.");
        protected Pattern positiveClassName = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            PatternParameter patternParameter = new PatternParameter(POSITIVE_CLASS_NAME_ID);
            if (parameterization.grab(patternParameter)) {
                this.positiveClassName = (Pattern)patternParameter.getValue();
            }
        }

        @Override
        protected OutlierROCCurve makeInstance() {
            return new OutlierROCCurve(this.positiveClassName);
        }
    }

    public static class ROCResult
    extends XYCurve {
        private double auc;

        public ROCResult(XYCurve xYCurve, double d) {
            super(xYCurve);
            this.auc = d;
        }

        public double getAUC() {
            return this.auc;
        }

        @Override
        public String getLongName() {
            return "ROC Curve";
        }

        @Override
        public String getShortName() {
            return "roc-curve";
        }

        @Override
        public void writeToText(TextWriterStream textWriterStream, String string) {
            textWriterStream.commentPrintLn("ROCAUC: " + this.auc);
            textWriterStream.flush();
            super.writeToText(textWriterStream, string);
        }
    }
}

