/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants;

import de.lmu.ifi.dbs.elki.data.HyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.index.tree.AbstractNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialPointLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.persistent.AbstractExternalizablePage;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Logger;

public abstract class AbstractRStarTreeNode<N extends AbstractRStarTreeNode<N, E>, E extends SpatialEntry>
extends AbstractNode<E>
implements SpatialNode<N, E> {
    public AbstractRStarTreeNode() {
    }

    public AbstractRStarTreeNode(int n, boolean bl, Class<? super E> clazz) {
        super(n, bl, clazz);
    }

    public ModifiableHyperBoundingBox computeMBR() {
        SpatialEntry spatialEntry = (SpatialEntry)this.getEntry(0);
        if (spatialEntry == null) {
            return null;
        }
        ModifiableHyperBoundingBox modifiableHyperBoundingBox = new ModifiableHyperBoundingBox(spatialEntry);
        for (int i = 1; i < this.numEntries; ++i) {
            modifiableHyperBoundingBox.extend((SpatialComparable)this.getEntry(i));
        }
        return modifiableHyperBoundingBox;
    }

    public boolean adjustEntry(E e) {
        SpatialDirectoryEntry spatialDirectoryEntry = (SpatialDirectoryEntry)e;
        ModifiableHyperBoundingBox modifiableHyperBoundingBox = this.computeMBR();
        boolean bl = false;
        if (spatialDirectoryEntry.hasMBR()) {
            int n = spatialDirectoryEntry.getDimensionality();
            for (int i = 0; i < n; ++i) {
                if (Math.abs(spatialDirectoryEntry.getMin(i) - modifiableHyperBoundingBox.getMin(i)) > 1.1754943508222875E-38) {
                    bl = true;
                } else {
                    if (!(Math.abs(spatialDirectoryEntry.getMax(i) - modifiableHyperBoundingBox.getMax(i)) > 1.1754943508222875E-38)) continue;
                    bl = true;
                }
                break;
            }
        } else {
            bl = true;
        }
        if (bl) {
            spatialDirectoryEntry.setMBR(modifiableHyperBoundingBox);
        }
        return bl;
    }

    public boolean adjustEntryIncremental(E e, SpatialComparable spatialComparable) {
        return ((SpatialDirectoryEntry)e).extendMBR(spatialComparable);
    }

    public final void integrityCheck(AbstractRStarTree<N, E, ?> abstractRStarTree) {
        if (this.isLeaf()) {
            for (int i = 0; i < this.getCapacity(); ++i) {
                SpatialEntry spatialEntry = (SpatialEntry)this.getEntry(i);
                if (i < this.getNumEntries() && spatialEntry == null) {
                    throw new RuntimeException("i < numEntries && entry == null");
                }
                if (i < this.getNumEntries() || spatialEntry == null) continue;
                throw new RuntimeException("i >= numEntries && entry != null");
            }
        } else {
            AbstractRStarTreeNode abstractRStarTreeNode = (AbstractRStarTreeNode)abstractRStarTree.getNode((SpatialEntry)this.getEntry(0));
            boolean bl = abstractRStarTreeNode.isLeaf();
            for (int i = 0; i < this.getCapacity(); ++i) {
                SpatialEntry spatialEntry = (SpatialEntry)this.getEntry(i);
                if (i < this.getNumEntries() && spatialEntry == null) {
                    throw new RuntimeException("i < numEntries && entry == null");
                }
                if (i >= this.getNumEntries() && spatialEntry != null) {
                    throw new RuntimeException("i >= numEntries && entry != null");
                }
                if (spatialEntry == null) continue;
                AbstractRStarTreeNode abstractRStarTreeNode2 = (AbstractRStarTreeNode)abstractRStarTree.getNode(spatialEntry);
                if (bl && !abstractRStarTreeNode2.isLeaf()) {
                    for (int j = 0; j < this.getNumEntries(); ++j) {
                        abstractRStarTree.getNode((SpatialEntry)this.getEntry(j));
                    }
                    throw new RuntimeException("Wrong Child in " + this + " at " + i);
                }
                if (!bl && abstractRStarTreeNode2.isLeaf()) {
                    throw new RuntimeException("Wrong Child: child id no leaf, but node is leaf!");
                }
                abstractRStarTreeNode2.integrityCheckParameters(this, i);
                abstractRStarTreeNode2.integrityCheck(abstractRStarTree);
            }
            if (LoggingConfiguration.DEBUG) {
                Logger.getLogger(this.getClass().getName()).fine("DirNode " + this.getPageID() + " ok!");
            }
        }
    }

    protected void integrityCheckParameters(N n, int n2) {
        SpatialEntry spatialEntry = (SpatialEntry)((AbstractNode)n).getEntry(n2);
        ModifiableHyperBoundingBox modifiableHyperBoundingBox = this.computeMBR();
        if (modifiableHyperBoundingBox == null) {
            return;
        }
        if (!SpatialUtil.equals(spatialEntry, modifiableHyperBoundingBox)) {
            String string = modifiableHyperBoundingBox.toString();
            String string2 = new HyperBoundingBox(spatialEntry).toString();
            throw new RuntimeException("Wrong MBR in node " + ((AbstractExternalizablePage)n).getPageID() + " at index " + n2 + " (child " + spatialEntry + ")" + "\nsoll: " + string + ",\n ist: " + string2);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(((SpatialEntry[])this.entries).length);
        for (SpatialEntry spatialEntry : (SpatialEntry[])this.entries) {
            if (spatialEntry == null) break;
            spatialEntry.writeExternal(objectOutput);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        if (this.isLeaf()) {
            this.entries = new SpatialPointLeafEntry[n];
            for (int i = 0; i < this.numEntries; ++i) {
                SpatialPointLeafEntry spatialPointLeafEntry = new SpatialPointLeafEntry();
                spatialPointLeafEntry.readExternal(objectInput);
                ((SpatialEntry[])this.entries)[i] = spatialPointLeafEntry;
            }
        } else {
            this.entries = new SpatialDirectoryEntry[n];
            for (int i = 0; i < this.numEntries; ++i) {
                SpatialDirectoryEntry spatialDirectoryEntry = new SpatialDirectoryEntry();
                spatialDirectoryEntry.readExternal(objectInput);
                ((SpatialEntry[])this.entries)[i] = spatialDirectoryEntry;
            }
        }
    }
}

