/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.logging;

import de.lmu.ifi.dbs.elki.logging.CLISmartHandler;
import de.lmu.ifi.dbs.elki.logging.Logging;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class LoggingConfiguration {
    public static boolean DEBUG = false;
    private static final String LOGGING_PROPERTIES_FILE = "logging.properties";
    private static final String TOPLEVEL_PACKAGE = "de.lmu.ifi.dbs.elki";
    private static final Logger LOGGER_GLOBAL_TOP = Logger.getLogger("");
    private static final Logger LOGGER_ELKI_TOP = Logger.getLogger("de.lmu.ifi.dbs.elki");
    private static final Logger LOGGER_TIME_TOP = Logger.getLogger("de.lmu.ifi.dbs.elki.workflow.AlgorithmStep");
    private static final String confbase = LoggingConfiguration.class.getPackage().getName();
    protected static LoggingConfiguration config = new LoggingConfiguration(confbase, "logging.properties");

    private LoggingConfiguration(String string, String string2) {
        this.privateReconfigureLogging(string, string2);
    }

    public static void reconfigureLogging(String string, String string2) {
        config.privateReconfigureLogging(string, string2);
    }

    private void privateReconfigureLogging(String string, String string2) {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = Logger.getLogger(LoggingConfiguration.class.getName());
        if (string == null) {
            string = "";
        }
        String string3 = string2;
        string3 = new File(string2).exists() ? string2 : string.replace('.', File.separatorChar) + File.separatorChar + string2;
        try {
            InputStream inputStream = LoggingConfiguration.openSystemFile(string3);
            logManager.readConfiguration(inputStream);
            InputStream inputStream2 = LoggingConfiguration.openSystemFile(string3);
            Properties properties = new Properties();
            properties.load(inputStream2);
            DEBUG = Boolean.parseBoolean(properties.getProperty("debug"));
            logger.info("Logging configuration read.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.log(Logging.Level.SEVERE, "Could not find logging configuration file: " + string3, fileNotFoundException);
        }
        catch (Exception exception) {
            logger.log(Logging.Level.SEVERE, "Failed to configure logging from file: " + string3, exception);
        }
    }

    private static InputStream openSystemFile(String string) throws FileNotFoundException {
        try {
            return new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string2 = string.replace(File.separatorChar, '/');
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(string2);
            if (inputStream == null) {
                throw fileNotFoundException;
            }
            return inputStream;
        }
    }

    public static void assertConfigured() {
    }

    public static void setVerbose(Level level) {
        if (level.intValue() <= Logging.Level.VERBOSE.intValue()) {
            if (LOGGER_GLOBAL_TOP.getLevel() == null || LOGGER_GLOBAL_TOP.getLevel().intValue() > level.intValue()) {
                LOGGER_GLOBAL_TOP.setLevel(level);
            }
            if (LOGGER_ELKI_TOP.getLevel() == null || LOGGER_ELKI_TOP.getLevel().intValue() > level.intValue()) {
                LOGGER_ELKI_TOP.setLevel(level);
            }
        } else {
            if (LOGGER_GLOBAL_TOP.getLevel() != null && (Logging.Level.VERBOSE.equals(LOGGER_GLOBAL_TOP.getLevel()) || Logging.Level.VERYVERBOSE.equals(LOGGER_GLOBAL_TOP.getLevel()))) {
                LOGGER_GLOBAL_TOP.setLevel(level);
            }
            if (LOGGER_ELKI_TOP.getLevel() != null && (Logging.Level.VERBOSE.equals(LOGGER_ELKI_TOP.getLevel()) || Logging.Level.VERYVERBOSE.equals(LOGGER_ELKI_TOP.getLevel()))) {
                LOGGER_ELKI_TOP.setLevel(level);
            }
        }
    }

    public static void setStatistics() {
        if (LOGGER_GLOBAL_TOP.getLevel() == null || LOGGER_GLOBAL_TOP.getLevel().intValue() > Logging.Level.STATISTICS.intValue()) {
            LOGGER_GLOBAL_TOP.setLevel(Logging.Level.STATISTICS);
        }
        if (LOGGER_ELKI_TOP.getLevel() == null || LOGGER_ELKI_TOP.getLevel().intValue() > Logging.Level.STATISTICS.intValue()) {
            LOGGER_ELKI_TOP.setLevel(Logging.Level.STATISTICS);
        }
        if (LOGGER_TIME_TOP.getLevel() == null || LOGGER_TIME_TOP.getLevel().intValue() > Logging.Level.STATISTICS.intValue()) {
            LOGGER_TIME_TOP.setLevel(Logging.Level.STATISTICS);
        }
    }

    public static void addHandler(Handler handler) {
        LogManager.getLogManager().getLogger("").addHandler(handler);
    }

    public static void replaceDefaultHandler(Handler handler) {
        Logger logger = LogManager.getLogManager().getLogger("");
        for (Handler handler2 : logger.getHandlers()) {
            if (!(handler2 instanceof CLISmartHandler)) continue;
            logger.removeHandler(handler2);
        }
        LoggingConfiguration.addHandler(handler);
    }

    public static void setLevelFor(String string, String string2) throws IllegalArgumentException {
        Logger logger = Logger.getLogger(string);
        if (logger == null) {
            throw new IllegalArgumentException("Logger not found.");
        }
        Level level = Logging.Level.parse(string2);
        logger.setLevel(level);
    }

    public static void setDefaultLevel(Level level) {
        Logger.getLogger(TOPLEVEL_PACKAGE).setLevel(level);
    }
}

