/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenPair;
import de.lmu.ifi.dbs.elki.math.linearalgebra.SortedEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.FilteredEigenPairs;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.ArrayList;

@Title(value="Weak Eigenpair Filter")
@Description(value="Sorts the eigenpairs in decending order of their eigenvalues and returns those eigenpairs, whose eigenvalue is above the average ('expected') eigenvalue.")
public class WeakEigenPairFilter
implements EigenPairFilter {
    public static final double DEFAULT_WALPHA = 0.95;
    private double walpha;

    public WeakEigenPairFilter(double d) {
        this.walpha = d;
    }

    @Override
    public FilteredEigenPairs filter(SortedEigenPairs sortedEigenPairs) {
        ArrayList<EigenPair> arrayList = new ArrayList<EigenPair>();
        ArrayList<EigenPair> arrayList2 = new ArrayList<EigenPair>();
        double d = 0.0;
        for (int i = 0; i < sortedEigenPairs.size(); ++i) {
            EigenPair eigenPair = sortedEigenPairs.getEigenPair(i);
            d += eigenPair.getEigenvalue();
        }
        double d2 = d / (double)sortedEigenPairs.size() * this.walpha;
        for (int i = 0; i < sortedEigenPairs.size(); ++i) {
            EigenPair eigenPair = sortedEigenPairs.getEigenPair(i);
            if (eigenPair.getEigenvalue() > d2) {
                arrayList.add(eigenPair);
                continue;
            }
            arrayList2.add(eigenPair);
        }
        if (arrayList.size() == 0) {
            return new FilteredEigenPairs(new ArrayList<EigenPair>(), arrayList2);
        }
        return new FilteredEigenPairs(arrayList2, arrayList);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID EIGENPAIR_FILTER_WALPHA = new OptionID("pca.filter.weakalpha", "The minimum strength of the statistically expected variance (1/n) share an eigenvector needs to have to be considered 'strong'.");
        private double walpha;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(EIGENPAIR_FILTER_WALPHA, 0.95);
            doubleParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.walpha = (Double)doubleParameter.getValue();
            }
        }

        @Override
        protected WeakEigenPairFilter makeInstance() {
            return new WeakEigenPairFilter(this.walpha);
        }
    }
}

