/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.spacefillingcurves;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.math.spacefillingcurves.AbstractSpatialSorter;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.List;

@Reference(authors="G. Peano", title="Sur une courbe, qui remplit toute une aire plane", booktitle="Mathematische Annalen, 36(1)")
public class PeanoSpatialSorter
extends AbstractSpatialSorter {
    @Override
    public <T extends SpatialComparable> void sort(List<T> list, int n, int n2, double[] dArray, int[] nArray) {
        this.peanoSort(list, n, n2, dArray, nArray, 0, BitsUtil.zero(dArray.length >> 1), false);
    }

    protected <T extends SpatialComparable> void peanoSort(List<T> list, int n, int n2, double[] dArray, int[] nArray, int n3, long[] lArray, boolean bl) {
        int n4;
        int n5;
        boolean bl2;
        int n6 = nArray != null ? nArray.length : dArray.length >> 1;
        int n7 = nArray != null ? nArray[n3] : n3;
        double d = dArray[2 * n7];
        double d2 = dArray[2 * n7 + 1];
        double d3 = (d + d + d2) / 3.0;
        double d4 = (d + d2 + d2) / 3.0;
        if (d2 - d4 < 1.0E-10 || d4 - d3 < 1.0E-10 || d3 - d < 1.0E-10) {
            bl2 = false;
            for (n5 = 0; n5 < n6; ++n5) {
                n4 = (nArray != null ? nArray[n5] : n5) << 1;
                if (!(dArray[n4 + 1] - dArray[n4] >= 1.0E-10)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                return;
            }
        }
        n4 = !(bl2 = BitsUtil.get(lArray, n7) ^ bl) ? ((n5 = this.pivotizeList1D(list, n, n2, n7, d3, false)) < n2 - 1 ? this.pivotizeList1D(list, n5, n2, n7, d4, false) : n5) : ((n5 = this.pivotizeList1D(list, n, n2, n7, d4, true)) < n2 - 1 ? this.pivotizeList1D(list, n5, n2, n7, d3, true) : n5);
        int n8 = (n3 + 1) % n6;
        if (n < n5 - 1) {
            dArray[2 * n7] = !bl2 ? d : d4;
            dArray[2 * n7 + 1] = !bl2 ? d3 : d2;
            this.peanoSort(list, n, n5, dArray, nArray, n8, lArray, bl);
        }
        if (n5 < n4 - 1) {
            BitsUtil.flipI(lArray, n7);
            dArray[2 * n7] = d3;
            dArray[2 * n7 + 1] = d4;
            this.peanoSort(list, n5, n4, dArray, nArray, n8, lArray, !bl);
            BitsUtil.flipI(lArray, n7);
        }
        if (n4 < n2 - 1) {
            dArray[2 * n7] = !bl2 ? d4 : d;
            dArray[2 * n7 + 1] = !bl2 ? d2 : d3;
            this.peanoSort(list, n4, n2, dArray, nArray, n8, lArray, bl);
        }
        dArray[2 * n7] = d;
        dArray[2 * n7 + 1] = d2;
    }
}

