/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.meta;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Arrays;

public class TrimmedEstimator<D extends Distribution>
implements DistributionEstimator<D> {
    private DistributionEstimator<D> inner;
    private double trim;

    public TrimmedEstimator(DistributionEstimator<D> distributionEstimator, double d) {
        this.inner = distributionEstimator;
        this.trim = d;
    }

    @Override
    public <A> D estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        int n = numberArrayAdapter.size(a);
        int n2 = (int)((double)n * this.trim) >> 1;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d;
            dArray[i] = d = numberArrayAdapter.getDouble(a, i);
        }
        Arrays.sort(dArray);
        double[] dArray2 = new double[n - 2 * n2];
        System.arraycopy(dArray, n2, dArray2, 0, dArray2.length);
        dArray = dArray2;
        n = dArray2.length;
        return this.inner.estimate(dArray, ArrayLikeUtil.DOUBLEARRAYADAPTER);
    }

    @Override
    public Class<? super D> getDistributionClass() {
        return this.inner.getDistributionClass();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.inner.toString() + ", trim=" + this.trim + ")";
    }

    public static class Parameterizer<D extends Distribution>
    extends AbstractParameterizer {
        public static final OptionID INNER_ID = new OptionID("trimmedestimate.inner", "Estimator to use on the trimmed data.");
        public static final OptionID TRIM_ID = new OptionID("trimmedestimate.trim", "Relative amount of data to trim on each end, must be 0 < trim < 0.5");
        private DistributionEstimator<D> inner;
        private double trim;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(INNER_ID, DistributionEstimator.class);
            if (parameterization.grab(objectParameter)) {
                this.inner = (DistributionEstimator)objectParameter.instantiateClass(parameterization);
            }
            DoubleParameter doubleParameter = new DoubleParameter(TRIM_ID);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            doubleParameter.addConstraint(CommonConstraints.LESS_THAN_HALF_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.trim = doubleParameter.doubleValue();
            }
        }

        @Override
        protected TrimmedEstimator<D> makeInstance() {
            return new TrimmedEstimator<D>(this.inner, this.trim);
        }
    }
}

