/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions;

import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.KernelDensityFunction;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public final class CosineKernelDensityFunction
implements KernelDensityFunction {
    public static final CosineKernelDensityFunction KERNEL = new CosineKernelDensityFunction();
    public static final double CANONICAL_BANDWIDTH = Math.pow(17.19015568929509, 0.2);
    private static final double STDDEV = Math.sqrt(0.1894305308612978);
    private static final double R = 0.6168502750680849;

    private CosineKernelDensityFunction() {
    }

    @Override
    public double density(double d) {
        return d < 1.0 ? 0.7853981633974483 * Math.cos(1.5707963267948966 * d) : 0.0;
    }

    @Override
    public double canonicalBandwidth() {
        return CANONICAL_BANDWIDTH;
    }

    @Override
    public double standardDeviation() {
        return STDDEV;
    }

    @Override
    public double getR() {
        return 0.6168502750680849;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected CosineKernelDensityFunction makeInstance() {
            return KERNEL;
        }
    }
}

