/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class LineReader
implements AutoCloseable {
    static final int BUFFER_SIZE = 4096;
    Reader in;
    char[] buffer;
    int pos = 0;
    int end = 0;

    public LineReader(InputStream inputStream) {
        this(new InputStreamReader(inputStream));
    }

    public LineReader(Reader reader) {
        this(reader, 4096);
    }

    public LineReader(InputStream inputStream, int n) {
        this(new InputStreamReader(inputStream), n);
    }

    public LineReader(Reader reader, int n) {
        this.in = reader;
        this.buffer = new char[n];
    }

    public boolean readLine(Appendable appendable) throws IOException {
        boolean bl = false;
        while (true) {
            if (this.pos < this.end) {
                char c;
                bl = true;
                if ((c = this.buffer[this.pos++]) == '\n') {
                    return bl;
                }
                if (c == '\r') continue;
                appendable.append(c);
                continue;
            }
            assert (this.pos >= this.end) : "Buffer wasn't empty when refilling!";
            this.end = this.in.read(this.buffer, 0, this.buffer.length);
            this.pos = 0;
            if (this.end < 0) break;
        }
        return bl;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }
}

