/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.gui;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.visualization.batikutil.JSVGSynchronizedCanvas;
import de.lmu.ifi.dbs.elki.visualization.savedialog.SVGSaveDialog;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class SimpleSVGViewer
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JSVGSynchronizedCanvas svgCanvas;

    public SimpleSVGViewer() throws HeadlessException {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setDefaultCloseOperation(2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(dimension.width - 50, dimension.height - 50);
        JMenuItem jMenuItem = new JMenuItem("Export");
        jMenuItem.setMnemonic(69);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimpleSVGViewer.this.saveCurrentPlot();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("Quit");
        jMenuItem2.setMnemonic(81);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimpleSVGViewer.this.close();
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenuItem);
        jMenuBar.add(jMenuItem2);
        jPanel.add("North", jMenuBar);
        this.svgCanvas = new JSVGSynchronizedCanvas();
        jPanel.add("Center", this.svgCanvas);
        this.getContentPane().add(jPanel);
        this.setExtendedState(6);
        this.setVisible(true);
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public void saveCurrentPlot() {
        SVGPlot sVGPlot = this.svgCanvas.getPlot();
        if (sVGPlot != null) {
            SVGSaveDialog.showSaveDialog(sVGPlot, 512, 512);
        } else {
            LoggingUtil.warning("saveCurrentPlot() called without a visible plot!");
        }
    }

    public void setPlot(SVGPlot sVGPlot) {
        this.svgCanvas.setPlot(sVGPlot);
    }
}

