/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.cluster;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.data.model.MedoidModel;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.exceptions.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.marker.MarkerLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ClusterMeanVisualization
extends AbstractVisFactory {
    private static final String NAME = "Cluster Means";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ScatterPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ScatterPlotProjector.class);
        while (iter.valid()) {
            ScatterPlotProjector scatterPlotProjector = iter.get();
            VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, scatterPlotProjector, scatterPlotProjector.getRelation(), this);
            visualizationTask.level = 101;
            visualizationTask.addUpdateFlags(4);
            visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            iter.advance();
        }
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        private static final String CSS_MEAN_CENTER = "mean-center";
        private static final String CSS_MEAN = "mean-marker";

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            Object object;
            this.setupCanvas();
            StylingPolicy stylingPolicy = this.context.getStylingPolicy();
            if (!(stylingPolicy instanceof ClusterStylingPolicy)) {
                return;
            }
            Clustering<?> clustering = ((ClusterStylingPolicy)stylingPolicy).getClustering();
            if (clustering.getAllClusters().size() == 0) {
                return;
            }
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            MarkerLibrary markerLibrary = styleLibrary.markers();
            double d = styleLibrary.getSize("plot.marker");
            if (!this.svgp.getCSSClassManager().contains(CSS_MEAN_CENTER)) {
                object = new CSSClass(this, CSS_MEAN_CENTER);
                ((CSSClass)object).setStatement("stroke", styleLibrary.getTextColor(""));
                ((CSSClass)object).setStatement("stroke-width", styleLibrary.getLineWidth("axis.tick") * 0.5);
                this.svgp.addCSSClassOrLogError((CSSClass)object);
            }
            if (!this.svgp.getCSSClassManager().contains(CSS_MEAN)) {
                object = new CSSClass(this, CSS_MEAN);
                ((CSSClass)object).setStatement("opacity", "0.7");
                this.svgp.addCSSClassOrLogError((CSSClass)object);
            }
            object = clustering.getAllClusters().iterator();
            int n = 0;
            while (object.hasNext()) {
                block8: {
                    Object object2;
                    Object object3;
                    double[] dArray;
                    block9: {
                        Cluster cluster = (Cluster)object.next();
                        Object m = cluster.getModel();
                        dArray = null;
                        try {
                            if (m instanceof MeanModel) {
                                object3 = ((MeanModel)m).getMean();
                                if (object3 == null) break block8;
                                dArray = this.proj.fastProjectDataToRenderSpace((NumberVector)object3);
                                break block9;
                            }
                            if (!(m instanceof MedoidModel) || (object3 = ((MedoidModel)m).getMedoid()) == null || (object2 = (NumberVector)this.rel.get((DBIDRef)object3)) == null) break block8;
                            dArray = this.proj.fastProjectDataToRenderSpace((NumberVector)object2);
                        }
                        catch (ObjectNotFoundException objectNotFoundException) {
                            break block8;
                        }
                    }
                    object3 = markerLibrary.useMarker(this.svgp, this.layer, dArray[0], dArray[1], n, d * 3.0);
                    SVGUtil.setAtt((Element)object3, "class", CSS_MEAN);
                    object2 = this.svgp.svgLine(dArray[0] - 0.7, dArray[1], dArray[0] + 0.7, dArray[1]);
                    SVGUtil.setAtt((Element)object2, "class", CSS_MEAN_CENTER);
                    Element element = this.svgp.svgLine(dArray[0], dArray[1] - 0.7, dArray[0], dArray[1] + 0.7);
                    SVGUtil.setAtt(element, "class", CSS_MEAN_CENTER);
                    this.layer.appendChild((Node)object2);
                    this.layer.appendChild(element);
                }
                ++n;
            }
            this.svgp.updateStyleElement();
        }
    }
}

